/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.resources.filemanagement.cmd.validation;

import com.sap.cloud.resources.filemanagement.cmd.validation.ResourceCheck;
import com.sap.cloud.resources.filemanagement.cmd.validation.ResourceFileValidationException;
import java.io.File;

public class InvalidFilenameCheck
extends ResourceCheck {
    private static final String SUPPORTED_CHARS_REGEX = "[a-zA-Z0-9\\.-]+";

    @Override
    protected void check(String filePath) throws ResourceFileValidationException {
        boolean containsUnsupportedCharacters;
        File file = new File(filePath);
        boolean bl = containsUnsupportedCharacters = !file.getName().matches(SUPPORTED_CHARS_REGEX);
        if (containsUnsupportedCharacters) {
            throw new ResourceFileValidationException("File name of the resource must be in English. Rename the file or specify the --name argument using characters from the following ranges: 'a' - 'z', 'A' - 'Z', '0' - '9', '.', '-'");
        }
    }
}

