/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.tunnelcommands.framework.executor;

import com.sap.core.tunnelcommands.framework.executor.CommandExecutionContext;
import com.sap.core.tunnelcommands.framework.executor.HttpClientProvider;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.core.tunnelcommands.framework.executor.PomInfo;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.log4j.Logger;

public class CommandTunnelRequestExecutor {
    private Logger LOGGER = Logger.getLogger(CommandTunnelRequestExecutor.class);
    private static final String DEFAULT_SERVICE_NAME = "persistence";
    private ICommandTunnelCommand command;
    private final String psaApi;
    private HttpResponseConsumingStrategy responseConsumerStrategy;
    private HttpUriRequestStrategy httpUriRequestStrategy;
    private CommandExecutionContext commandExecutionContext;

    public CommandTunnelRequestExecutor(HttpUriRequestStrategy restCallStrategy, HttpResponseConsumingStrategy httpUriRequestStrategy, ICommandTunnelCommand command, String psaApiPath) {
        this(new CommandExecutionContext(), restCallStrategy, httpUriRequestStrategy, command, psaApiPath);
    }

    public CommandTunnelRequestExecutor(CommandExecutionContext context, HttpUriRequestStrategy restCallStrategy, HttpResponseConsumingStrategy httpUriRequestStrategy, ICommandTunnelCommand command, String psaApiPath) {
        this.httpUriRequestStrategy = restCallStrategy;
        this.responseConsumerStrategy = httpUriRequestStrategy;
        this.psaApi = psaApiPath;
        this.command = command;
        this.commandExecutionContext = context;
    }

    public void executeRequest() throws CommandException {
        this.executeRequest(75000);
    }

    public void executeRequest(int socketTimeout) throws CommandException {
        if (this.LOGGER.isInfoEnabled()) {
            this.LOGGER.info((Object)(CommandTunnelRequestExecutor.class.getSimpleName() + ".executeRequest() called for command [" + this.command.getName() + "]" + " (version: " + PomInfo.getPomVersion() + ")"));
        }
        System.out.println("");
        HttpClient httpClient = null;
        try {
            httpClient = this.getClientWithBasicAuth(socketTimeout);
            HttpUriRequest httpUriRequest = this.httpUriRequestStrategy.getHttpUriRequest(this.getRequestUri());
            this.LOGGER.debug((Object)(" Request URI: " + httpUriRequest.getMethod() + " " + httpUriRequest.getURI().toString()));
            HttpResponse response = null;
            try {
                response = httpClient.execute(httpUriRequest, this.commandExecutionContext.getHttpContext());
            }
            catch (UnknownHostException e) {
                throw new CommandException((Throwable)new UnknownHostException(httpUriRequest.getURI().toString()), 210);
            }
            catch (SocketTimeoutException timeout) {
                this.wrapAndThrowCommandException("Request timeout occurred during remote call to " + httpUriRequest.getURI().toString() + ". (The operation might still have been executed successfully.)", timeout, 210);
            }
            if (response == null) {
                this.LOGGER.error((Object)("Internal error: Response of " + httpUriRequest.toString() + " is empty."));
                throw new CommandException("Failed due to an internal error", 210);
            }
            if (response.getStatusLine() == null) {
                this.LOGGER.error((Object)(" Internal error: Response StatusLine of " + httpUriRequest.toString() + " empty."));
                throw new CommandException("Failed due to internal error", 210);
            }
            this.responseConsumerStrategy.consume(new HttpResponseContext(response, httpUriRequest, this.command));
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            this.wrapAndThrowCommandException("Unexpected exception occurred", e, 210);
        }
    }

    String getRequestUri() {
        String serviceName = this.command.getServiceName();
        if (serviceName == null || serviceName.length() == 0) {
            serviceName = DEFAULT_SERVICE_NAME;
        }
        String serviceUriPath = "/services/v1/instances/" + this.command.getAccount() + "/" + serviceName + "/" + this.command.getVersion() + "/" + this.psaApi;
        return CommandTunnelRequestExecutor.getRequestUri(this.command.getHost(), serviceUriPath);
    }

    static String getRequestUri(String host, String serviceUriPath) {
        String result = CommandTunnelRequestExecutor.getCommandTunnelHost(host);
        result = serviceUriPath.startsWith("/") ? result + serviceUriPath.substring(1) : result + serviceUriPath;
        return result;
    }

    static String getCommandTunnelHost(String host) {
        String result;
        host = host.toLowerCase();
        String schemePrefix = null;
        if (host.startsWith("https://")) {
            schemePrefix = "https://";
        } else if (host.startsWith("http://")) {
            schemePrefix = "http://";
        } else {
            throw new CommandException("Host '" + host + "' does not start with '" + "https://" + "' or with '" + "http://" + "'.", 41);
        }
        host = host.substring(schemePrefix.length());
        if (!host.startsWith("services")) {
            host = "services." + host;
        }
        if (!(result = schemePrefix + host).endsWith("/")) {
            result = result + "/";
        }
        return result;
    }

    HttpClient getClientWithBasicAuth(int socketTimeout) throws URISyntaxException, IOException {
        HttpClient httpClient = this.commandExecutionContext.getHttpClient();
        if (httpClient == null) {
            httpClient = HttpClientProvider.createClientWithBasicAuth(this.command.getUser(), this.command.getPassword(), this.getRequestUri(), socketTimeout);
            this.commandExecutionContext.setHttpClient(httpClient);
        }
        return httpClient;
    }

    private void wrapAndThrowCommandException(String newMsg, Exception cause, int exitCode) {
        throw new CommandException(newMsg, (Throwable)new Exception(newMsg, cause), exitCode);
    }
}

