/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.tunnelcommands.framework.executor;

import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.utils.security.logon.LogonUtils;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import org.apache.http.HttpResponse;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.apache.log4j.Logger;

public abstract class DefaultResponseConsumingStrategy
implements HttpResponseConsumingStrategy {
    public static final String INTERNAL_ERROR = "An internal error occurred.";
    private Logger LOGGER = Logger.getLogger(DefaultResponseConsumingStrategy.class);

    @Override
    public void consume(HttpResponseContext context) throws CommandException {
        String msg;
        int statusCode = context.getStatusCode();
        if (statusCode == 401) {
            String reason = LogonUtils.getAuthenticationFailureErrorMessage((HttpResponse)context.getResponse());
            if (reason == null) {
                reason = "Please check the user name and password, and try again.";
            }
            msg = "Could not verify the identity of user " + context.getCommand().getUser() + ".\n" + reason;
        } else {
            msg = statusCode == 500 ? "An internal server error occurred." : (statusCode == 503 ? "The server is currently unavailable." : (statusCode == 403 ? "Authorization error - the execution was rejected." : (statusCode == 408 || statusCode == 504 ? "Request timed out." : (statusCode == 400 || statusCode == 404 ? "A problem occurred." : "An unexpected internal problem occurred (status code " + statusCode + ")"))));
        }
        this.throwCommandExceptionWithContentInfoAndLog(msg, context);
    }

    public void throwCommandExceptionWithContentInfoAndLog(String detailMsg, HttpResponseContext context) {
        this.throwCommandExceptionWithContentInfoAndLog(detailMsg, null, context);
    }

    public void throwCommandExceptionWithContentInfoAndLog(String detailMsg, String additionalLogMessage, HttpResponseContext context) {
        this.throwCommandExceptionWithContentInfoAndLog(detailMsg, additionalLogMessage, context, null);
    }

    public void throwCommandExceptionWithContentInfoAndLog(String detailMsg, String additionalLogMessage, HttpResponseContext context, String replaceContextMessage) {
        int exitCode;
        String responseContentString;
        this.logResponseContent(detailMsg, additionalLogMessage, context, replaceContextMessage);
        String exceptionMsg = detailMsg == null || detailMsg.trim().length() == 0 ? "" : detailMsg;
        String responseContentTypeValue = context.getResponseContentTypeValue();
        if (responseContentTypeValue != null && responseContentTypeValue.startsWith("text/plain") && (responseContentString = replaceContextMessage != null ? replaceContextMessage : context.getResponseContentString()) != null) {
            if (exceptionMsg.length() > 0) {
                exceptionMsg = exceptionMsg + "\n";
            }
            exceptionMsg = exceptionMsg + responseContentString;
        }
        switch (context.getStatusCode()) {
            case 401: {
                exitCode = 110;
                break;
            }
            default: {
                exitCode = 1;
            }
        }
        throw new CommandException(exceptionMsg, exitCode);
    }

    private void logResponseContent(String detailedMsg, String additionalLogMessage, HttpResponseContext context, String replaceContextMessage) {
        this.LOGGER.error((Object)detailedMsg);
        if (additionalLogMessage != null) {
            this.LOGGER.error((Object)additionalLogMessage);
        }
        this.LOGGER.error((Object)("request URI: " + context.getHttpUriRequest().getURI().toString()));
        this.LOGGER.error((Object)("statusCode: " + context.getStatusCode() + " " + this.getStatusCodeDetailMsg(context)));
        this.LOGGER.error((Object)("contentType: " + context.getResponseContentTypeValue()));
        this.LOGGER.error((Object)("content: " + context.getResponseContentString()));
        if (replaceContextMessage != null) {
            this.LOGGER.error((Object)("replace content message: " + replaceContextMessage));
        }
    }

    private String getStatusCodeDetailMsg(HttpResponseContext context) {
        String reason = EnglishReasonPhraseCatalog.INSTANCE.getReason(context.getStatusCode(), null);
        return reason == null ? "" : reason;
    }
}

