/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.tunnelcommands.framework.executor;

import com.sap.core.utils.infrastructure.validation.AuthenticationException;
import com.sap.core.utils.infrastructure.validation.HostValidationException;
import com.sap.core.utils.infrastructure.validation.LandscapeHostValidator;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.http.client.HttpClient;

public class HttpClientProvider {
    public static final int DEFAULT_SOCKET_TIMEOUT = 75000;
    private static HttpClientProvider instance;

    private static HttpClientProvider getInstance() {
        if (instance == null) {
            instance = new HttpClientProvider();
        }
        return instance;
    }

    public static HttpClient createClientWithBasicAuth(String username, String password, String url, int socketTimeout) throws MalformedURLException, ValidationException {
        return HttpClientProvider.getInstance().createClientWithBasicAuthentication(username, password, url, socketTimeout);
    }

    protected HttpClient createClientWithBasicAuthentication(String username, String password, String url, int socketTimeout) throws MalformedURLException, ValidationException {
        try {
            return LandscapeHostValidator.getHttpClient((URL)new URL(url), (String)"/", (int)socketTimeout, (String)username, (String)password, (boolean)true);
        }
        catch (HostValidationException e) {
            throw new ValidationException((Throwable)e, 41);
        }
        catch (AuthenticationException e) {
            throw new SecurityException((Throwable)e, 110);
        }
        catch (IOException e) {
            throw new CommandException((Throwable)e, 1);
        }
    }

    public static String encodeURLString(String inputString) throws CommandException {
        try {
            return URLEncoder.encode(inputString, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new CommandException("Failed to encode " + inputString, (Throwable)e, 1);
        }
    }
}

