/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.tunnelcommands.framework.executor;

import com.google.gson.JsonObject;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.util.JsonObjectPasswordFilter;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.log4j.Logger;

public class HttpPostStrategy
implements HttpUriRequestStrategy {
    private final JsonObject entity;
    private Logger LOGGER = Logger.getLogger(HttpResponseContext.class);

    public HttpPostStrategy(JsonObject entity) {
        this.entity = entity;
    }

    public HttpPostStrategy() {
        this(null);
    }

    @Override
    public HttpUriRequest getHttpUriRequest(String uri) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(uri);
        if (this.entity != null) {
            this.LOGGER.info((Object)("Post with " + HttpPostStrategy.maskPasswordsForLogging(this.entity)));
            httpPost.setEntity((HttpEntity)new StringEntity(this.entity.toString(), ContentType.APPLICATION_JSON));
        }
        return httpPost;
    }

    static String maskPasswordsForLogging(JsonObject entity) {
        JsonObject temp = new JsonObjectPasswordFilter(entity).getFilteredObject();
        return temp.toString();
    }
}

