/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.tunnelcommands.framework.executor;

import com.google.gson.JsonObject;
import com.sap.core.tunnelcommands.framework.executor.HttpPostStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.log4j.Logger;

public class HttpPutStrategy
implements HttpUriRequestStrategy {
    private final JsonObject entity;
    private Logger LOGGER = Logger.getLogger(HttpResponseContext.class);

    public HttpPutStrategy(JsonObject entity) {
        this.entity = entity;
    }

    public HttpPutStrategy() {
        this(null);
    }

    @Override
    public HttpUriRequest getHttpUriRequest(String uri) throws UnsupportedEncodingException {
        HttpPut httpPut = new HttpPut(uri);
        if (this.entity != null) {
            this.LOGGER.info((Object)("Put with " + HttpPostStrategy.maskPasswordsForLogging(this.entity)));
            httpPut.setEntity((HttpEntity)new StringEntity(this.entity.toString(), ContentType.APPLICATION_JSON));
        }
        return httpPut;
    }
}

