/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.tunnelcommands.framework.executor;

import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpResponseContext {
    private HttpResponse response;
    private HttpUriRequest httpUriRequest;
    private ICommandTunnelCommand command;
    private boolean contentTypeSet = false;
    private String contentTypeValue = null;
    private boolean contentStringSet = false;
    private String contentString;
    private Logger LOGGER = Logger.getLogger(HttpResponseContext.class);

    public HttpResponseContext(HttpResponse response, HttpUriRequest httpUriRequest, ICommandTunnelCommand command) {
        this.response = response;
        this.httpUriRequest = httpUriRequest;
        this.command = command;
    }

    public ICommandTunnelCommand getCommand() {
        return this.command;
    }

    private String getContentTypeValue() {
        return this.contentTypeValue;
    }

    private void setContentTypeValue(String contentTypeValue) {
        this.contentTypeSet = true;
        this.contentTypeValue = contentTypeValue;
    }

    private String getContentString() {
        return this.contentString;
    }

    private void setContentString(String contentString) {
        this.contentStringSet = true;
        this.contentString = contentString;
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public HttpUriRequest getHttpUriRequest() {
        return this.httpUriRequest;
    }

    public String getResponseContentTypeValue() {
        if (!this.contentTypeSet) {
            this.setContentTypeValue(this.readContentTypeValue());
        }
        return this.getContentTypeValue();
    }

    private String readContentTypeValue() {
        if (this.response == null || this.response.getEntity() == null) {
            return null;
        }
        return EntityUtils.getContentMimeType((HttpEntity)this.response.getEntity());
    }

    public String getResponseContentString() {
        if (!this.contentStringSet) {
            this.setContentString(this.readContentString());
        }
        return this.getContentString();
    }

    private String readContentString() {
        if (this.response == null || this.response.getEntity() == null) {
            return null;
        }
        if (this.response.getEntity().getContentLength() == 0L) {
            return null;
        }
        HttpEntity entity = this.response.getEntity();
        try {
            String contentString = EntityUtils.toString((HttpEntity)entity);
            if (contentString != null && contentString.trim().length() == 0) {
                contentString = null;
            }
            return contentString;
        }
        catch (IOException e) {
            this.LOGGER.error((Object)("An unexpected exception occurred while reading the content of httpResponse.getEntity() for " + this.httpUriRequest.toString() + "."), (Throwable)e);
            return null;
        }
    }
}

