/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.tunnelcommands.framework.executor;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.sap.core.tunnelcommands.framework.executor.DefaultResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;

public abstract class JsonConsumingStrategy<T>
extends DefaultResponseConsumingStrategy {
    private static final String APPLICATION_JSON = "application/json";
    private Class<T> classOfT;

    public JsonConsumingStrategy(Class<T> classOfT) {
        this.classOfT = classOfT;
    }

    @Override
    public void consume(HttpResponseContext context) throws CommandException {
        super.consume(context);
    }

    public boolean isJsonMimeType(HttpResponseContext context) {
        HttpEntity entity = context.getResponse().getEntity();
        if (entity == null) {
            return false;
        }
        return APPLICATION_JSON.equalsIgnoreCase(EntityUtils.getContentMimeType((HttpEntity)entity));
    }

    public T getJsonObject(HttpResponseContext context) {
        HttpEntity entity = context.getResponse().getEntity();
        if (entity == null) {
            return null;
        }
        Reader inReader = this.validateResponseAndGetReader(context, entity);
        return this.getJsonObject(inReader);
    }

    public List<T> getJsonArray(HttpResponseContext context) {
        HttpEntity entity = context.getResponse().getEntity();
        if (entity == null) {
            return null;
        }
        Reader inReader = this.validateResponseAndGetReader(context, entity);
        JsonElement json = new JsonParser().parse(inReader);
        JsonArray jsonArray = json.getAsJsonArray();
        Iterator iterator = jsonArray.iterator();
        ArrayList<Object> objectList = new ArrayList<Object>();
        Gson gson = new Gson();
        while (iterator.hasNext()) {
            JsonElement element = (JsonElement)iterator.next();
            Object instance = gson.fromJson(element, this.classOfT);
            objectList.add(instance);
        }
        return objectList;
    }

    T getJsonObject(Reader inReader) {
        return (T)new Gson().fromJson(inReader, this.classOfT);
    }

    private Reader validateResponseAndGetReader(HttpResponseContext context, HttpEntity entity) {
        InputStreamReader inReader;
        if (!this.isJsonMimeType(context)) {
            this.throwCommandExceptionWithContentInfoAndLog("An internal error occurred.", "Unexpected response: The content type of " + context.getHttpUriRequest().getURI().toString() + " was " + EntityUtils.getContentMimeType((HttpEntity)entity) + " but " + APPLICATION_JSON + " was expected.", context);
        }
        try {
            String contentCharSet = EntityUtils.getContentCharSet((HttpEntity)entity);
            if (contentCharSet == null) {
                contentCharSet = "UTF-8";
            }
            inReader = new InputStreamReader(entity.getContent(), contentCharSet);
        }
        catch (Exception e) {
            throw new CommandException("Could not parse the json:" + e.getCause(), 210);
        }
        return inReader;
    }
}

