/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.tunnelcommands.util;

import java.io.PrintStream;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;

public class FormattedTable {
    public static final String CELL_INDENTATION = "  ";
    public static final String COLL_SEPARATION = "  ";
    private String[] headerLine;
    private Collection<String[]> rows = new ArrayList<String[]>();
    private int columnsCount;

    public FormattedTable(String ... headers) {
        if (headers == null || headers.length == 0) {
            throw new IllegalArgumentException("headers must not be empty or null");
        }
        for (int i = 0; i < headers.length; ++i) {
            if (headers[i] != null) continue;
            throw new IllegalArgumentException("header[" + i + "] must not be null");
        }
        this.headerLine = (String[])headers.clone();
        this.columnsCount = headers.length;
    }

    public void addRow(String ... strings) {
        if (strings == null || strings.length != this.columnsCount) {
            throw new InvalidParameterException("Expected an array of length " + this.columnsCount);
        }
        String[] row = (String[])strings.clone();
        for (int i = 0; i < this.columnsCount; ++i) {
            if (row[i] != null) continue;
            row[i] = "";
        }
        this.rows.add(row);
    }

    public String[] getFormattedRow() {
        int[] columnWidth = this.calculateColumnWidth();
        ArrayList<String> formatedRows = new ArrayList<String>();
        formatedRows.add(this.getFormattedHeaderLine(columnWidth));
        for (String[] row : this.rows) {
            StringBuilder formattedRow = new StringBuilder();
            for (int i = 0; i < this.columnsCount; ++i) {
                String formattedCell = this.getFromattedCell(row[i], columnWidth[i]);
                formattedRow.append(formattedCell);
                if (i >= this.columnsCount - 1) continue;
                formattedRow.append("  ");
            }
            formatedRows.add(formattedRow.toString());
        }
        return formatedRows.toArray(new String[0]);
    }

    private String getFormattedHeaderLine(int[] columnWidth) {
        StringBuilder formattedHeaderLine = new StringBuilder();
        for (int i = 0; i < this.headerLine.length; ++i) {
            String formattedHeader = this.getFormattedHeader(this.headerLine[i], columnWidth[i]);
            formattedHeaderLine.append(formattedHeader);
            if (i >= this.columnsCount - 1) continue;
            formattedHeaderLine.append("  ");
        }
        return formattedHeaderLine.toString();
    }

    private int[] calculateColumnWidth() {
        int i;
        int[] maxLength = new int[this.columnsCount];
        for (i = 0; i < this.columnsCount; ++i) {
            maxLength[i] = 0;
        }
        for (i = 0; i < this.columnsCount; ++i) {
            maxLength[i] = Math.max(maxLength[i], FormattedTable.getLength(this.headerLine[i]));
        }
        for (String[] row : this.rows) {
            for (int i2 = 0; i2 < this.columnsCount; ++i2) {
                maxLength[i2] = Math.max(maxLength[i2], FormattedTable.getLength("  " + row[i2]));
            }
        }
        return maxLength;
    }

    private static int getLength(String str) {
        if (str == null) {
            return 0;
        }
        return str.length();
    }

    private String getFormattedHeader(String header, int length) {
        if (length == 0) {
            return "";
        }
        return String.format("%-" + length + "s", header);
    }

    String getFromattedCell(String content, int columnWidth) {
        if (columnWidth == "  ".length()) {
            return "  ";
        }
        int length = columnWidth - "  ".length();
        return "  " + String.format("%-" + length + "s", content);
    }

    public String toString() {
        return super.toString();
    }

    public void printTo(PrintStream out) {
        for (String row : this.getFormattedRow()) {
            out.println(row);
        }
    }

    public void printTo(PrintStream out, String rowPrefix) {
        for (String row : this.getFormattedRow()) {
            out.println(rowPrefix + row);
        }
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }
}

