/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.tunnelcommands.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class JsonObjectPasswordFilter {
    private final String replacement = "****";
    private final JsonObject inputJson;
    private Selector selector = new PasswordSelector();

    public JsonObjectPasswordFilter(JsonObject input) {
        this.inputJson = input;
    }

    public JsonObject getFilteredObject() {
        JsonObject output = new JsonObject();
        return this.filter(this.inputJson, output);
    }

    private JsonObject filter(JsonObject source, JsonObject target) {
        Set entries = source.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            Object value = this.selector.isKeyRelevant(key) ? new JsonPrimitive("****") : (JsonElement)entry.getValue();
            target.add(key, value);
        }
        return target;
    }

    private class PasswordSelector
    implements Selector {
        private PasswordSelector() {
        }

        @Override
        public boolean isKeyRelevant(String key) {
            return key.toLowerCase(Locale.ENGLISH).contains("pass");
        }
    }

    private static interface Selector {
        public boolean isKeyRelevant(String var1);
    }
}

