/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.tenant.common;

public class TenantData {
    private String tenantId;
    private String tenantDescription;
    private String tenantName;
    private String alias;
    private String accountName;
    private String accountDisplayName;
    private String customerId;

    public TenantData(TenantData tenantData) {
        this.assertNotNull(tenantData);
        this.tenantId = tenantData.getId();
        this.tenantDescription = tenantData.getDescription();
        this.tenantName = tenantData.getName();
        this.alias = tenantData.getAlias();
        this.accountName = tenantData.getAccountName();
        this.accountDisplayName = tenantData.getAccountDisplayName();
        this.customerId = tenantData.getCustomerId();
    }

    @Deprecated
    public TenantData(String tenantId, String tenantDescription, String tenantName, String alias) {
        this.assertNotNull(alias, tenantId);
        this.tenantId = tenantId;
        this.tenantDescription = tenantDescription;
        this.tenantName = tenantName;
        this.alias = alias;
        this.accountName = null;
    }

    public TenantData(String tenantId, String tenantDescription, String tenantName, String alias, String accountName) {
        this.assertNotNull(alias, tenantId, accountName);
        this.tenantId = tenantId;
        this.tenantDescription = tenantDescription;
        this.tenantName = tenantName;
        this.alias = alias;
        this.accountName = accountName;
    }

    public TenantData(String tenantId, String tenantDescription, String tenantName, String alias, String accountName, String accountDisplayName, String customerId) {
        this(tenantId, tenantDescription, tenantName, alias, accountName);
        this.accountDisplayName = accountDisplayName;
        if (accountDisplayName != null && accountDisplayName.isEmpty()) {
            this.accountDisplayName = null;
        }
        this.customerId = customerId;
    }

    private void assertNotNull(Object ... objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object == null) {
                throw new NullPointerException();
            }
            ++n2;
        }
    }

    public String getDescription() {
        return this.tenantDescription;
    }

    public String getId() {
        return this.tenantId;
    }

    public String getName() {
        return this.tenantName;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getAccountDisplayName() {
        return this.accountDisplayName;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    @Deprecated
    public String getCrmId() {
        return null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.accountName == null ? 0 : this.accountName.hashCode());
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        result = 31 * result + (this.tenantDescription == null ? 0 : this.tenantDescription.hashCode());
        result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        result = 31 * result + (this.tenantName == null ? 0 : this.tenantName.hashCode());
        result = 31 * result + (this.accountDisplayName == null ? 0 : this.accountDisplayName.hashCode());
        result = 31 * result + (this.customerId == null ? 0 : this.customerId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TenantData other = (TenantData)obj;
        if (this.accountName == null ? other.accountName != null : !this.accountName.equals(other.accountName)) {
            return false;
        }
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        if (this.tenantDescription == null ? other.tenantDescription != null : !this.tenantDescription.equals(other.tenantDescription)) {
            return false;
        }
        if (this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId)) {
            return false;
        }
        if (this.tenantName == null ? other.tenantName != null : !this.tenantName.equals(other.tenantName)) {
            return false;
        }
        if (this.accountDisplayName == null ? other.accountDisplayName != null : !this.accountDisplayName.equals(other.accountDisplayName)) {
            return false;
        }
        return !(this.customerId == null ? other.customerId != null : !this.customerId.equals(other.customerId));
    }
}

