/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.tenant.common;

public class TenantUtils {
    private static final String DOT = ".";
    private static final String TENANT_SEPARATOR = "-";
    private static final String WWW_PREFIX = "www.";

    public String getTenantId(String hostNameFromServerName) {
        if (hostNameFromServerName == null) {
            return null;
        }
        int indexOfWWW = hostNameFromServerName.indexOf(WWW_PREFIX);
        indexOfWWW = indexOfWWW == -1 ? 0 : (indexOfWWW += WWW_PREFIX.length());
        int indexOfDot = hostNameFromServerName.indexOf(DOT, indexOfWWW);
        int indexOfDash = hostNameFromServerName.indexOf(TENANT_SEPARATOR);
        if (indexOfDash == -1) {
            return null;
        }
        if (indexOfDash > indexOfDot) {
            return null;
        }
        String tenantHost = hostNameFromServerName.substring(indexOfDash + 1, indexOfDot);
        return tenantHost;
    }

    public String getUrlPrefix(String serverName) {
        if (serverName == null) {
            return null;
        }
        int indexOfWWW = serverName.indexOf(WWW_PREFIX);
        indexOfWWW = indexOfWWW == -1 ? 0 : (indexOfWWW += WWW_PREFIX.length());
        int indexOfDot = serverName.indexOf(DOT, indexOfWWW);
        int indexOfDash = serverName.indexOf(TENANT_SEPARATOR);
        if (indexOfDot == -1) {
            indexOfDot = serverName.length();
        }
        if (indexOfDash > indexOfDot) {
            return null;
        }
        if (indexOfDash == -1) {
            String hostname = serverName.substring(indexOfWWW, indexOfDot);
            return hostname;
        }
        String hostname = serverName.substring(indexOfWWW, indexOfDash);
        return hostname;
    }
}

