/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl;

import com.sap.core.connectivity.apiext.impl.ConnectivityContext;
import com.sap.core.connectivity.apiext.impl.cache.util.VisibleForTesting;
import com.sap.core.connectivity.apiext.impl.context.AuthContext;
import com.sap.core.connectivity.apiext.impl.context.Header;
import com.sap.core.connectivity.apiext.impl.context.ProxyAuthContext;
import com.sap.core.connectivity.apiext.impl.context.ProxyContext;
import com.sap.core.connectivity.apiext.impl.util.UriConverter;
import com.sap.core.connectivity.apiext.internal.api.client.ConnectivityClient;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import org.apache.log4j.Logger;

public class BasicConnectivityClient
implements ConnectivityClient {
    private static final Logger log = Logger.getLogger(BasicConnectivityClient.class);
    protected final ConnectivityContext context;

    public BasicConnectivityClient(ConnectivityContext context) {
        this.context = context;
    }

    @VisibleForTesting
    protected HttpURLConnection createConnection(URL url) throws IOException {
        ProxyContext determinedProxyContext = this.determineProxyContext();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(determinedProxyContext.getProxy());
        this.configureTimeouts(connection);
        this.configureSSL(connection);
        this.configureAuthentication(connection, determinedProxyContext);
        return connection;
    }

    public <T> T execute(ConnectivityClient.Operation<T> operation) throws IOException {
        return this.execute(this.context.getURL(), operation);
    }

    public <T> T execute(String uri, ConnectivityClient.Operation<T> operation) throws IOException {
        try {
            URI requestURI = new URI(uri);
            URI convertedURI = this.convertRequestURI(requestURI);
            if (!requestURI.toString().equals(convertedURI.toString()) && log.isInfoEnabled()) {
                log.info((Object)String.format("Converted URI from [%s] to [%s]", requestURI.toString(), convertedURI.toString()));
            }
            return this.execute(convertedURI.toURL(), operation);
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    protected void configureTimeouts(HttpURLConnection connection) {
        connection.setConnectTimeout(this.context.getConnectTimeoutMillis());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Configured connect timeout: " + this.context.getConnectTimeoutMillis()));
        }
        connection.setReadTimeout(this.context.getReadTimeoutMillis());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Configured read timeout: " + this.context.getReadTimeoutMillis()));
        }
    }

    protected void configureSSL(HttpURLConnection connection) {
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection secureConnection = (HttpsURLConnection)connection;
            secureConnection.setSSLSocketFactory(this.context.getSSLSocketFactory());
            secureConnection.setHostnameVerifier(this.context.getHostnameVerifier());
            log.debug((Object)"Connection over HTTPS");
        } else {
            log.debug((Object)"Connection over plain HTTP");
        }
    }

    protected void configureAuthentication(HttpURLConnection connection, ProxyContext proxyContext) {
        this.configureAuth(connection, "server", this.context.getAuthContext());
        this.configureAuth(connection, "proxy", proxyContext.getAuthContext());
    }

    protected URI convertRequestURI(URI requestURI) throws URISyntaxException {
        URI destinationURI = this.context.getURL().toURI();
        return new UriConverter().convert(requestURI, destinationURI, true);
    }

    protected <T> T execute(URL url, ConnectivityClient.Operation<T> operation) throws IOException {
        HttpURLConnection connection = this.createConnection(url);
        long timestampBeforeExecute = System.currentTimeMillis();
        try {
            Object response = operation.execute(connection);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Request to " + url + " took " + (System.currentTimeMillis() - timestampBeforeExecute) + " milliseconds."));
            }
            Object object = response;
            return (T)object;
        }
        catch (IOException ioe) {
            long executionTime = System.currentTimeMillis() - timestampBeforeExecute;
            StringBuilder message = new StringBuilder();
            message.append("Problem with executing request to URL: ").append(url).append(" Execution time: ").append(executionTime).append(" ms, Connect timeout: ").append(connection.getConnectTimeout()).append(" ms,  Read timeout : ").append(connection.getReadTimeout()).append(" ms, Exception message: ").append(ioe.getMessage());
            log.error((Object)message.toString(), (Throwable)ioe);
            throw new IOException(message.toString(), ioe);
        }
        finally {
            connection.disconnect();
        }
    }

    protected ProxyContext determineProxyContext() {
        ProxyContext determinedProxyContext = this.context.getProxyContext() != null ? this.context.getProxyContext() : ProxyContext.NO_PROXY_CONTEXT;
        this.logDebug(determinedProxyContext);
        return determinedProxyContext;
    }

    protected final void logDebug(ProxyContext proxyContext) {
        if (log.isDebugEnabled()) {
            ProxyAuthContext authContext = proxyContext.getAuthContext();
            log.debug((Object)String.format("Determined proxy [%s], proxy auth [%s]", proxyContext.getProxy(), authContext != null ? authContext.getAuthType() : "NO_AUTHENTICATION"));
        }
    }

    private void configureAuth(HttpURLConnection connection, String authTargetType, AuthContext authContext) {
        if (authContext != null) {
            List<Header> authHeaders = authContext.getHeaders();
            if (authHeaders != null && !authHeaders.isEmpty()) {
                this.logDebugConfiguringAuthentication(authTargetType, authContext.getAuthType(), connection.getURL());
                for (Header header : authHeaders) {
                    connection.setRequestProperty((String)header.getKey(), (String)header.getValue());
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Set header with name: " + (String)header.getKey()));
                }
            }
        } else {
            this.logDebugConfiguringAuthentication(authTargetType, "NO_AUTHENTICATION", connection.getURL());
        }
    }

    private void logDebugConfiguringAuthentication(String authTargetType, String authType, URL url) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Configuring authentication for connecting to %s. Auth type: %s. URL: %s", authTargetType, authType, url));
        }
    }
}

