/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl;

import com.sap.core.connectivity.apiext.impl.ConnectivityContext;
import com.sap.core.connectivity.apiext.impl.context.AuthContext;
import com.sap.core.connectivity.apiext.impl.context.ProxyContext;
import java.net.URL;
import java.util.EnumSet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public class ConnectivityContextBuilder {
    private URL url;
    private SSLSocketFactory sslSocketFactory;
    private int connectTimeoutMillis = 30000;
    private int readTimeoutMillis = 60000;
    private ProxyContext proxyContext = ProxyContext.NO_PROXY_CONTEXT;
    private HostnameVerifier hostnameVerifier;
    private AuthContext authContext;
    private final EnumSet<FieldFlag> fieldFlags = EnumSet.noneOf(FieldFlag.class);
    private final ConnectivityContext connectivityContext;

    public ConnectivityContextBuilder() {
        this.connectivityContext = null;
    }

    public ConnectivityContextBuilder(ConnectivityContext connectivityContext) {
        this.connectivityContext = connectivityContext;
    }

    public ConnectivityContextBuilder url(URL url) {
        this.url = url;
        this.enableFlag(FieldFlag.URL);
        return this;
    }

    public ConnectivityContextBuilder sslSocketFactory(SSLSocketFactory factory) {
        this.sslSocketFactory = factory;
        this.enableFlag(FieldFlag.SSL_SOCKET_FACTORY);
        return this;
    }

    public ConnectivityContextBuilder connectTimeoutMillis(int millis) {
        this.connectTimeoutMillis = millis;
        this.enableFlag(FieldFlag.CONNECT_TIMEOUT_MILLIS);
        return this;
    }

    public ConnectivityContextBuilder readTimeoutMillis(int millis) {
        this.readTimeoutMillis = millis;
        this.enableFlag(FieldFlag.READ_TIMEOUT_MILLIS);
        return this;
    }

    public ConnectivityContextBuilder proxyContext(ProxyContext context) {
        this.proxyContext = context;
        this.enableFlag(FieldFlag.PROXY_CONTEXT);
        return this;
    }

    public ConnectivityContextBuilder authContext(AuthContext context) {
        this.authContext = context;
        this.enableFlag(FieldFlag.AUTH_CONTEXT);
        return this;
    }

    public ConnectivityContextBuilder hostnameVerifier(HostnameVerifier verifier) {
        this.hostnameVerifier = verifier;
        this.enableFlag(FieldFlag.HOSTNAME_VERIFIER);
        return this;
    }

    public ConnectivityContext build() {
        return new ConnectivityContext(){

            @Override
            public URL getURL() {
                if (ConnectivityContextBuilder.this.connectivityContext != null && !ConnectivityContextBuilder.this.isFlagEnabled(FieldFlag.URL)) {
                    return ConnectivityContextBuilder.this.connectivityContext.getURL();
                }
                return ConnectivityContextBuilder.this.url;
            }

            @Override
            public SSLSocketFactory getSSLSocketFactory() {
                if (ConnectivityContextBuilder.this.connectivityContext != null && !ConnectivityContextBuilder.this.isFlagEnabled(FieldFlag.SSL_SOCKET_FACTORY)) {
                    return ConnectivityContextBuilder.this.connectivityContext.getSSLSocketFactory();
                }
                return ConnectivityContextBuilder.this.sslSocketFactory;
            }

            @Override
            public int getConnectTimeoutMillis() {
                if (ConnectivityContextBuilder.this.connectivityContext != null && !ConnectivityContextBuilder.this.isFlagEnabled(FieldFlag.CONNECT_TIMEOUT_MILLIS)) {
                    return ConnectivityContextBuilder.this.connectivityContext.getConnectTimeoutMillis();
                }
                return ConnectivityContextBuilder.this.connectTimeoutMillis;
            }

            @Override
            public int getReadTimeoutMillis() {
                if (ConnectivityContextBuilder.this.connectivityContext != null && !ConnectivityContextBuilder.this.isFlagEnabled(FieldFlag.READ_TIMEOUT_MILLIS)) {
                    return ConnectivityContextBuilder.this.connectivityContext.getReadTimeoutMillis();
                }
                return ConnectivityContextBuilder.this.readTimeoutMillis;
            }

            @Override
            public ProxyContext getProxyContext() {
                if (ConnectivityContextBuilder.this.connectivityContext != null && !ConnectivityContextBuilder.this.isFlagEnabled(FieldFlag.PROXY_CONTEXT)) {
                    return ConnectivityContextBuilder.this.connectivityContext.getProxyContext();
                }
                return ConnectivityContextBuilder.this.proxyContext;
            }

            @Override
            public AuthContext getAuthContext() {
                if (ConnectivityContextBuilder.this.connectivityContext != null && !ConnectivityContextBuilder.this.isFlagEnabled(FieldFlag.AUTH_CONTEXT)) {
                    return ConnectivityContextBuilder.this.connectivityContext.getAuthContext();
                }
                return ConnectivityContextBuilder.this.authContext;
            }

            @Override
            public HostnameVerifier getHostnameVerifier() {
                if (ConnectivityContextBuilder.this.connectivityContext != null && !ConnectivityContextBuilder.this.isFlagEnabled(FieldFlag.HOSTNAME_VERIFIER)) {
                    return ConnectivityContextBuilder.this.connectivityContext.getHostnameVerifier();
                }
                return ConnectivityContextBuilder.this.hostnameVerifier;
            }
        };
    }

    private void enableFlag(FieldFlag flag) {
        this.fieldFlags.add(flag);
    }

    private boolean isFlagEnabled(FieldFlag flag) {
        return this.fieldFlags.contains((Object)flag);
    }

    private static enum FieldFlag {
        URL,
        SSL_SOCKET_FACTORY,
        CONNECT_TIMEOUT_MILLIS,
        READ_TIMEOUT_MILLIS,
        PROXY_CONTEXT,
        AUTH_CONTEXT,
        HOSTNAME_VERIFIER;

    }
}

