/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.authentication;

import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.apiext.impl.authentication.AppToAppSSOProviderException;
import com.sap.core.connectivity.apiext.impl.authentication.util.UserAccessor;
import com.sap.core.jpaas.security.saml2.service.SAML2TokenService;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.User;
import org.apache.log4j.Logger;

public class AppToAppSSOProvider {
    private static final String A2A_SSO_AUTHENTICATION_TYPE_KEY = "Authentication";
    private static final String A2A_SSO_AUTHENTICATION_TYPE_VALUE = "AppToAppSSO";
    private static final Logger logger = Logger.getLogger(AppToAppSSOProvider.class);

    public String getSSOToken(String requestURL, DestinationConfiguration destinationConfiguration) {
        if (logger.isDebugEnabled()) {
            String debugMessage = "Generating SAML2 response for request URL [" + requestURL + "]";
            if (destinationConfiguration != null) {
                debugMessage = String.valueOf(debugMessage) + " and destination [" + destinationConfiguration.getProperty("Name") + "]";
            }
            logger.debug((Object)debugMessage);
        }
        String audience = null;
        if (destinationConfiguration != null) {
            String authenticationType = destinationConfiguration.getProperty(A2A_SSO_AUTHENTICATION_TYPE_KEY);
            if (!A2A_SSO_AUTHENTICATION_TYPE_VALUE.equals(authenticationType)) {
                throw new IllegalArgumentException("Invalid authentication type. Expected type is: AppToAppSSO");
            }
            audience = destinationConfiguration.getProperty("saml2_audience");
            if (logger.isDebugEnabled() && audience != null) {
                logger.debug((Object)("Will issue saml2 response for audiende [" + audience + "]"));
            }
        }
        try {
            User authenticatedUser = UserAccessor.getCurrentUser();
            if (authenticatedUser == null) {
                throw new IllegalArgumentException("No logged-in user");
            }
        }
        catch (PersistenceException e) {
            throw new AppToAppSSOProviderException("Unexpected error while trying to retrieve logged-in user", e);
        }
        try {
            String saml2Token = SAML2TokenService.getInstance().generateSSOToken(requestURL, audience);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Issued saml2 response: [" + saml2Token + "]"));
            }
            return saml2Token;
        }
        catch (SAML2Exception e) {
            throw new AppToAppSSOProviderException(e.getMessage(), e);
        }
    }
}

