/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.authentication;

import com.sap.core.connectivity.api.authentication.AuthenticationHeader;
import com.sap.core.connectivity.api.authentication.AuthenticationHeaderProvider;
import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.apiext.impl.authentication.AppToAppSSOProvider;
import com.sap.core.connectivity.apiext.impl.authentication.AuthenticationHeaderImpl;
import com.sap.core.connectivity.apiext.impl.authentication.PrincipalInformationProvider;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuth2ClientCredentialsTokenProvider;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuth2SAMLBearerAssertionProvider;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.sap.SAPAssertionProvider;
import com.sap.engine.lib.security.login.SingleSignOnCredential;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.DatatypeConverter;

public class AuthenticationHeaderProviderImpl
implements AuthenticationHeaderProvider {
    private static final String APP_TO_APP_SSO_HEADER_NAME = "Authorization";
    private static final String SAML2_TOKEN_TYPE = "SAML2.0 ";
    private static final String PRINCIPAL_PROPAGATION_HEADER_NAME = "SAP-Connectivity-Authentication";
    private static final String SAP_ASSERTION_HEADER_KEY = "Cookie";
    private static final String SAP_ASSERTION_HEADER_PREFIX = "MYSAPSSO2=";
    private static final String OAUTH_ASSERTION_HEADER_KEY = "Authorization";
    private static final String OAUTH_SUCCESSFACTORS_HEADER_KEY = "X-SF-CT-API";
    private static final String OAUTH_ASSERTION_HEADER_PREFIX = "Bearer ";
    private static final String OAUTH_SUCCESSFACTORS_HEADER = "xxxxxx";
    private static final OAuth2ClientCredentialsTokenProvider oAuth2ClientCredentialsTokenProvider = new OAuth2ClientCredentialsTokenProvider();

    public AuthenticationHeader getAppToAppSSOHeader(String requestURL) {
        return this.getApptoAppSSOHeader(requestURL, null);
    }

    public AuthenticationHeader getApptoAppSSOHeader(String requestURL, DestinationConfiguration destinationConfiguration) {
        AppToAppSSOProvider appToAppSSOProvider = new AppToAppSSOProvider();
        String saml2Token = appToAppSSOProvider.getSSOToken(requestURL, destinationConfiguration);
        return new AuthenticationHeaderImpl("Authorization", SAML2_TOKEN_TYPE + saml2Token);
    }

    public AuthenticationHeader getPrincipalPropagationHeader() {
        PrincipalInformationProvider principalProvider = new PrincipalInformationProvider();
        SingleSignOnCredential singleSignOnCredential = principalProvider.getPrincipalCredentials();
        byte[] tokenBytes = singleSignOnCredential.getValue().getBytes(Charset.forName("UTF-8"));
        StringBuilder headerValue = new StringBuilder();
        headerValue.append(singleSignOnCredential.getType());
        headerValue.append(" ");
        headerValue.append(DatatypeConverter.printBase64Binary((byte[])tokenBytes));
        return new AuthenticationHeaderImpl(PRINCIPAL_PROPAGATION_HEADER_NAME, headerValue.toString());
    }

    public AuthenticationHeader getSAPAssertionHeader(DestinationConfiguration destinationConfiguration) {
        SAPAssertionProvider sapAssertionProvider = new SAPAssertionProvider(destinationConfiguration);
        String sapAssertionToken = sapAssertionProvider.getAssertionToken();
        return new AuthenticationHeaderImpl(SAP_ASSERTION_HEADER_KEY, SAP_ASSERTION_HEADER_PREFIX + sapAssertionToken);
    }

    public List<AuthenticationHeader> getOAuth2SAMLBearerAssertionHeaders(DestinationConfiguration destinationConfiguration) {
        OAuth2SAMLBearerAssertionProvider oauthAssertionProvider = new OAuth2SAMLBearerAssertionProvider(destinationConfiguration);
        String oauthAssertionToken = oauthAssertionProvider.getAssertionToken();
        ArrayList<AuthenticationHeader> authenticationHeaders = new ArrayList<AuthenticationHeader>(2);
        authenticationHeaders.add(new AuthenticationHeaderImpl(OAUTH_SUCCESSFACTORS_HEADER_KEY, OAUTH_SUCCESSFACTORS_HEADER));
        authenticationHeaders.add(new AuthenticationHeaderImpl("Authorization", OAUTH_ASSERTION_HEADER_PREFIX + oauthAssertionToken));
        return authenticationHeaders;
    }

    public AuthenticationHeader getOAuth2ClientCredentialsHeader(DestinationConfiguration destinationConfiguration) {
        String accessToken = oAuth2ClientCredentialsTokenProvider.getAccessToken(destinationConfiguration);
        return new AuthenticationHeaderImpl("Authorization", OAUTH_ASSERTION_HEADER_PREFIX + accessToken);
    }
}

