/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.authentication;

import com.google.gson.Gson;
import com.sap.core.connectivity.apiext.impl.authentication.PrincipalInformationProviderException;
import com.sap.core.connectivity.apiext.impl.authentication.util.UserAccessor;
import com.sap.engine.lib.security.login.SingleSignOnCredential;
import com.sap.engine.lib.security.login.SubjectWrapper;
import com.sap.security.auth.service.UserSession;
import com.sap.security.saml2.commons.SAML2Principal;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.UnsupportedUserAttributeException;
import com.sap.security.um.user.User;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

public class PrincipalInformationProvider {
    private static final String ATTR_KEY_EMAIL = "email";
    private static final String ATTR_KEY_MAIL = "mail";
    private static final Logger logger = Logger.getLogger(PrincipalInformationProvider.class);
    private static final String GENERIC_PRINCIPAL_PROPAGATION_TOKEN_TYPE = "PrincipalPropagation";

    public SingleSignOnCredential getPrincipalCredentials() {
        try {
            SAML2Credential saml2Credential = this.getSAML2Credentials();
            if (saml2Credential.isUnsigned()) {
                logger.debug((Object)"Received unsigned SAML2Credential, will fallback to generic credential.");
                return this.getGenericCredentials();
            }
            return saml2Credential;
        }
        catch (PrincipalInformationProviderException e) {
            logger.debug((Object)"No valid SAML2 token found ", (Throwable)e);
            return this.getGenericCredentials();
        }
    }

    private SAML2Credential getSAML2Credentials() throws PrincipalInformationProviderException {
        UserSession userSession = UserSession.getInstance();
        SubjectWrapper subjectWrapper = (SubjectWrapper)userSession.getSubject();
        if (subjectWrapper == null) {
            throw new PrincipalInformationProviderException("No logged-in user through SAML2 authentication");
        }
        Subject subject = subjectWrapper.getSubject();
        if (subject == null || subject.getPrincipals() == null) {
            throw new PrincipalInformationProviderException("No logged-in user through SAML2 authentication");
        }
        Set<SingleSignOnCredential> privateCredentials = subject.getPrivateCredentials(SingleSignOnCredential.class);
        if (privateCredentials.isEmpty()) {
            throw new PrincipalInformationProviderException("No single sign-on credential available for user " + subjectWrapper.getPrincipal().getName());
        }
        if (privateCredentials.size() != 1) {
            throw new PrincipalInformationProviderException("More than one single sign-on credential available for user " + subjectWrapper.getPrincipal().getName());
        }
        final SingleSignOnCredential singleSignOnCredential = privateCredentials.iterator().next();
        if (!"SAML2".equals(singleSignOnCredential.getType())) {
            throw new PrincipalInformationProviderException("SSO credential type not supported: " + singleSignOnCredential.getType());
        }
        final Principal principal = subjectWrapper.getPrincipal();
        return new SAML2Credential(){

            public String getValue() {
                return singleSignOnCredential.getValue();
            }

            public String getType() {
                return singleSignOnCredential.getType();
            }

            @Override
            public boolean isUnsigned() {
                boolean isUnsigned = false;
                if (principal instanceof SAML2Principal) {
                    SAML2Principal saml2Principal = (SAML2Principal)principal;
                    isUnsigned = saml2Principal.isAssertionUnsigned();
                }
                return isUnsigned;
            }
        };
    }

    private SingleSignOnCredential getGenericCredentials() {
        GenericUserModel genericUserModel;
        block5: {
            genericUserModel = null;
            try {
                User authenticatedUser = UserAccessor.getCurrentUser();
                if (authenticatedUser != null) {
                    genericUserModel = new GenericUserModel(authenticatedUser.getName());
                    Set userAttributes = authenticatedUser.listAttributes();
                    for (String attr : userAttributes) {
                        String attrValue = authenticatedUser.getAttribute(attr);
                        if (attrValue == null) continue;
                        genericUserModel.addAttribute(attr, attrValue);
                    }
                    this.speciallyHandleEmailAttributes(genericUserModel, authenticatedUser, userAttributes);
                    break block5;
                }
                throw new IllegalArgumentException("No logged-in user");
            }
            catch (PersistenceException e) {
                throw new PrincipalInformationProviderException("Unexpected error while trying to retrieve logged-in user", e);
            }
            catch (UnsupportedUserAttributeException e) {
                throw new PrincipalInformationProviderException("Unexpected error! Tried fetching an unsupported user attribute", e);
            }
        }
        Gson gson = new Gson();
        final String jsonModel = gson.toJson((Object)genericUserModel);
        SingleSignOnCredential ssoCredentials = new SingleSignOnCredential(){

            public String getValue() {
                return jsonModel;
            }

            public String getType() {
                return PrincipalInformationProvider.GENERIC_PRINCIPAL_PROPAGATION_TOKEN_TYPE;
            }
        };
        return ssoCredentials;
    }

    private void speciallyHandleEmailAttributes(GenericUserModel genericUserModel, User authenticatedUser, Set<String> userAttributes) throws UnsupportedUserAttributeException {
        if (userAttributes.contains(ATTR_KEY_MAIL) && !userAttributes.contains(ATTR_KEY_EMAIL)) {
            genericUserModel.addAttribute(ATTR_KEY_EMAIL, authenticatedUser.getAttribute(ATTR_KEY_MAIL));
        } else if (userAttributes.contains(ATTR_KEY_EMAIL) && !userAttributes.contains(ATTR_KEY_MAIL)) {
            genericUserModel.addAttribute(ATTR_KEY_MAIL, authenticatedUser.getAttribute(ATTR_KEY_EMAIL));
        }
    }

    private static class GenericUserModel {
        private String name;
        private Map<String, String> attributes = new HashMap<String, String>();

        public GenericUserModel() {
        }

        public GenericUserModel(String name) {
            this();
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void addAttribute(String userAttribute, String value) {
            this.attributes.put(userAttribute, value);
        }
    }

    private static interface SAML2Credential
    extends SingleSignOnCredential {
        public boolean isUnsigned();
    }
}

