/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.authentication.assertion;

import com.sap.core.connectivity.apiext.impl.authentication.assertion.AssertionProviderException;
import com.sap.core.connectivity.apiext.impl.authentication.util.UserAccessor;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.UnsupportedUserAttributeException;
import com.sap.security.um.user.User;

public abstract class AbstractAssertionProvider {
    private final String systemUser;

    protected AbstractAssertionProvider(String systemUser) {
        this.systemUser = systemUser;
    }

    protected abstract String getAssertionType();

    protected abstract AssertionProviderException createAssertionProviderSpecificException(String var1);

    protected abstract AssertionProviderException createAssertionProviderSpecificException(Throwable var1);

    protected abstract AssertionProviderException createAssertionProviderSpecificException(String var1, Throwable var2);

    protected abstract String getAssertionToken(String var1);

    public String getAssertionToken() {
        String userId = this.getCurrentUserId();
        try {
            return this.getAssertionToken(userId);
        }
        catch (AssertionProviderException ex) {
            throw this.createAssertionProviderSpecificException("Cannot return " + this.getAssertionType() + " because of " + ex, ex);
        }
    }

    protected String getCurrentUserId() {
        if (this.systemUser != null && !this.systemUser.isEmpty()) {
            return this.systemUser;
        }
        try {
            User currentUser = UserAccessor.getCurrentUser();
            String userId = this.getUserId(currentUser);
            if (userId != null) {
                return userId;
            }
            throw new IllegalArgumentException("Cannot generate " + this.getAssertionType() + " because there is no user logged in the current thread.");
        }
        catch (PersistenceException e) {
            throw this.createAssertionProviderSpecificException("Cannot generate " + this.getAssertionType() + " because of " + e.toString(), e);
        }
        catch (UnsupportedUserAttributeException e) {
            throw this.createAssertionProviderSpecificException("Cannot generate " + this.getAssertionType() + " because of " + e.toString(), e);
        }
    }

    protected String getUserId(User currentUser) throws PersistenceException, UnsupportedUserAttributeException {
        if (currentUser != null) {
            return currentUser.getName();
        }
        return null;
    }
}

