/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth;

import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuth2ClientCredentialsTokenServiceClient;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuth2ClientCredentialsTokenServiceContext;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuthToken;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuthTokenCache;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuthTokenGenerationException;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuthTokenGenerator;
import com.sap.core.connectivity.apiext.impl.cache.AbstractExpiringCache;

class OAuth2ClientCredentialsConfigurationCache
extends AbstractExpiringCache<DestinationConfiguration, OAuthToken>
implements OAuthTokenCache<DestinationConfiguration> {
    private static final int CACHE_SIZE = 1000;

    OAuth2ClientCredentialsConfigurationCache() {
        super(1000);
    }

    @Override
    protected OAuthToken generateValueForKey(DestinationConfiguration destinationConfiguration) throws OAuthTokenGenerationException {
        OAuth2ClientCredentialsTokenServiceContext oauthContext = new OAuth2ClientCredentialsTokenServiceContext(destinationConfiguration);
        OAuth2ClientCredentialsTokenServiceClient oAuthTokenServiceClient = new OAuth2ClientCredentialsTokenServiceClient(oauthContext);
        OAuthTokenGenerator<String> oauthTokenGenerator = new OAuthTokenGenerator<String>(oAuthTokenServiceClient);
        return oauthTokenGenerator.generateOAuthToken(oauthContext.getOAuthConfiguration().getClientId());
    }
}

