/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth;

import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuth2ClientCredentialsConfigurationCache;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuthToken;
import org.apache.log4j.Logger;

public class OAuth2ClientCredentialsTokenProvider {
    private static final Logger LOGGER = Logger.getLogger(OAuth2ClientCredentialsTokenProvider.class);
    private static final OAuth2ClientCredentialsConfigurationCache O_AUTH2_CLIENT_CREDENTIALS_CONFIGURATION_CACHE = new OAuth2ClientCredentialsConfigurationCache();

    public String getAccessToken(DestinationConfiguration destinationConfiguration) {
        String destinationName = destinationConfiguration.getProperty("Name");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("OAuth 2.0 Client Credentials Destination [" + destinationName + "], . Requesting token..."));
        }
        OAuthToken oauthToken = (OAuthToken)O_AUTH2_CLIENT_CREDENTIALS_CONFIGURATION_CACHE.getValue(destinationConfiguration);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("OAuth 2.0 Client Credentials Destination [" + destinationName + "], Returning token: [" + oauthToken + "]"));
        }
        return oauthToken.getToken();
    }
}

