/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth;

import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuth2ClientCredentialsConfiguration;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuth2ClientCredentialsTokenServiceContext;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuthTokenServiceClient;
import com.sap.core.connectivity.apiext.impl.util.Optional;
import java.util.HashMap;

class OAuth2ClientCredentialsTokenServiceClient
extends OAuthTokenServiceClient<String> {
    private static final String GRANT_TYPE_PROPERTY = "grant_type";
    private static final String CLIENT_ID_PROPERTY = "client_id";
    private static final String CLIENT_SECRET_PROPERTY = "client_secret";
    private static final String SCOPE_PROPERTY = "scope";
    private static final String GRANT_TYPE_CLIENT_CREDENTIALS = "client_credentials";
    private OAuth2ClientCredentialsConfiguration oAuth2ClientCredentialsConfiguration;

    public OAuth2ClientCredentialsTokenServiceClient(OAuth2ClientCredentialsTokenServiceContext context) {
        super(context);
        this.oAuth2ClientCredentialsConfiguration = context.getOAuthConfiguration();
    }

    @Override
    protected String getPostData(String clientId) {
        String clientSecret = this.oAuth2ClientCredentialsConfiguration.getClientSecret();
        Optional<String> scopes = Optional.fromNullable(this.oAuth2ClientCredentialsConfiguration.getScope());
        return this.buildClientCredentialsPayload(clientId, clientSecret, scopes);
    }

    private String buildClientCredentialsPayload(String clientId, String clientSecret, Optional<String> scopes) {
        HashMap<String, String> postData = new HashMap<String, String>(4);
        postData.put(GRANT_TYPE_PROPERTY, GRANT_TYPE_CLIENT_CREDENTIALS);
        postData.put(CLIENT_ID_PROPERTY, clientId);
        postData.put(CLIENT_SECRET_PROPERTY, clientSecret);
        if (scopes.isPresent()) {
            postData.put(SCOPE_PROPERTY, scopes.get());
        }
        return this.encodePostData(postData);
    }
}

