/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth;

import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuth2ClientCredentialsConfiguration;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuthTokenServiceContext;

class OAuth2ClientCredentialsTokenServiceContext
extends OAuthTokenServiceContext {
    private OAuth2ClientCredentialsConfiguration oAuth2ClientCredentialsConfiguration;

    public OAuth2ClientCredentialsTokenServiceContext(DestinationConfiguration destinationConfiguration) {
        super(destinationConfiguration);
    }

    @Override
    protected void validateConfiguration() {
        super.validateConfiguration();
        if (!"OAuth2ClientCredentials".equals(this.getConfigurationProperty("Authentication"))) {
            throw new IllegalArgumentException("The expected authentication type is 'OAuth2ClientCredentials'");
        }
    }

    @Override
    public OAuth2ClientCredentialsConfiguration getOAuthConfiguration() {
        if (this.oAuth2ClientCredentialsConfiguration == null) {
            this.oAuth2ClientCredentialsConfiguration = new OAuth2ClientCredentialsConfiguration();
            this.oAuth2ClientCredentialsConfiguration.setClientId(this.getConfigurationProperty("clientId"));
            this.oAuth2ClientCredentialsConfiguration.setClientSecret(this.getConfigurationProperty("clientSecret"));
            this.oAuth2ClientCredentialsConfiguration.setScope(this.getConfigurationProperty("scope"));
            this.oAuth2ClientCredentialsConfiguration.setTokenServiceURL(this.getConfigurationProperty("tokenServiceURL"));
            this.oAuth2ClientCredentialsConfiguration.setTokenServiceUser(this.getConfigurationProperty("tokenServiceUser"));
            this.oAuth2ClientCredentialsConfiguration.setTokenServicePassword(this.getConfigurationProperty("tokenServicePassword"));
        }
        return this.oAuth2ClientCredentialsConfiguration;
    }
}

