/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth;

import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.AbstractAssertionProvider;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.AssertionProviderException;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuth2SAMLBearerAssertionProviderException;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuth2SamlBearerAssertionConfigurationCache;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuthToken;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuthTokenCache;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.UnsupportedUserAttributeException;
import com.sap.security.um.user.User;
import org.apache.log4j.Logger;

public class OAuth2SAMLBearerAssertionProvider
extends AbstractAssertionProvider {
    private static final Logger log = Logger.getLogger(OAuth2SAMLBearerAssertionProvider.class);
    private static final OAuth2SamlBearerAssertionConfigurationCache oauthConfigurationCache = new OAuth2SamlBearerAssertionConfigurationCache();
    private final OAuthTokenCache<String> oauthTokenCache;
    private final String destinationName;
    private final String userIdSource;

    public OAuth2SAMLBearerAssertionProvider(DestinationConfiguration destinationConfiguration) {
        super(destinationConfiguration.getProperty("SystemUser"));
        this.destinationName = destinationConfiguration.getProperty("Name");
        this.userIdSource = destinationConfiguration.getProperty("userIdSource");
        try {
            this.oauthTokenCache = (OAuthTokenCache)oauthConfigurationCache.getValue(destinationConfiguration);
        }
        catch (AssertionProviderException ex) {
            throw this.createAssertionProviderSpecificException(ex);
        }
    }

    @Override
    protected String getAssertionToken(String userID) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("OAuth 2.0 Destination [" + this.destinationName + "], User [" + userID + "]. Requesting token..."));
        }
        OAuthToken oauthToken = (OAuthToken)this.oauthTokenCache.getValue(userID);
        if (log.isDebugEnabled()) {
            log.debug((Object)("OAuth 2.0 Destination [" + this.destinationName + "], User [" + userID + "]. Returning token: [" + oauthToken + "]"));
        }
        return oauthToken.getToken();
    }

    @Override
    public String getUserId(User currentUser) throws PersistenceException, UnsupportedUserAttributeException {
        if (this.userIdSource != null && currentUser != null) {
            String userId = currentUser.getAttribute(this.userIdSource);
            if (userId != null) {
                return userId;
            }
            throw new IllegalArgumentException(String.format("Cannot generate %s because the logged in user does not have congired %s attribute.", this.getAssertionType(), this.userIdSource));
        }
        return super.getUserId(currentUser);
    }

    @Override
    protected AssertionProviderException createAssertionProviderSpecificException(String message) {
        return new OAuth2SAMLBearerAssertionProviderException(message);
    }

    @Override
    protected AssertionProviderException createAssertionProviderSpecificException(Throwable cause) {
        return new OAuth2SAMLBearerAssertionProviderException(cause);
    }

    @Override
    protected AssertionProviderException createAssertionProviderSpecificException(String message, Throwable cause) {
        return new OAuth2SAMLBearerAssertionProviderException(message, cause);
    }

    @Override
    protected String getAssertionType() {
        return "OAuth 2.0 SAML Bearer Assertion";
    }
}

