/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth;

import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuth2SamlBearerAssertionConfiguration;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuthTokenServiceContext;
import java.text.MessageFormat;

class OAuth2SAMLBearerAssertionTokenServiceContext
extends OAuthTokenServiceContext {
    private OAuth2SamlBearerAssertionConfiguration oAuth2SamlBearerAssertionConfiguration;

    OAuth2SAMLBearerAssertionTokenServiceContext(DestinationConfiguration destinationConfiguration) {
        super(destinationConfiguration);
    }

    @Override
    protected void validateConfiguration() {
        super.validateConfiguration();
        if ("OAuth2SAMLBearerAssertion".equals(this.getConfigurationProperty("Authentication"))) {
            if (this.isConfigurationPropertyInitialized("userIdSource") && this.isConfigurationPropertyInitialized("SystemUser")) {
                throw new IllegalArgumentException(MessageFormat.format("Cannot generate OAuth 2.0 SAML Bearer Assertion because of an invalid configuration. {0} can not be used in conjunction with {1}", "userIdSource", "SystemUser"));
            }
        } else {
            throw new IllegalArgumentException("The expected authentication type is 'OAuth2SAMLBearerAssertion'");
        }
    }

    @Override
    public OAuth2SamlBearerAssertionConfiguration getOAuthConfiguration() {
        if (this.oAuth2SamlBearerAssertionConfiguration == null) {
            this.oAuth2SamlBearerAssertionConfiguration = new OAuth2SamlBearerAssertionConfiguration();
            this.oAuth2SamlBearerAssertionConfiguration.setAudience(this.getConfigurationProperty("audience"));
            this.oAuth2SamlBearerAssertionConfiguration.setClientKey(this.getConfigurationProperty("clientKey"));
            this.oAuth2SamlBearerAssertionConfiguration.setTokenServiceURL(this.getConfigurationProperty("tokenServiceURL"));
            this.oAuth2SamlBearerAssertionConfiguration.setTokenServiceUser(this.getConfigurationProperty("tokenServiceUser"));
            this.oAuth2SamlBearerAssertionConfiguration.setTokenServicePassword(this.getConfigurationProperty("tokenServicePassword"));
            this.oAuth2SamlBearerAssertionConfiguration.setUserScopeQualifier(this.getConfigurationProperty("nameQualifier"));
            this.oAuth2SamlBearerAssertionConfiguration.setCompanyId(this.getConfigurationProperty("companyId"));
            this.oAuth2SamlBearerAssertionConfiguration.setAssertionIssuer(this.getConfigurationProperty("assertionIssuer"));
            this.oAuth2SamlBearerAssertionConfiguration.setScope(this.getConfigurationProperty("scope"));
            this.oAuth2SamlBearerAssertionConfiguration.setAuthnContextClassRef(this.getConfigurationProperty("authnContextClassRef"));
            this.oAuth2SamlBearerAssertionConfiguration.setNameIdFormat(this.getConfigurationProperty("nameIdFormat"));
            this.oAuth2SamlBearerAssertionConfiguration.setUserIdSource(this.getConfigurationProperty("userIdSource"));
        }
        return this.oAuth2SamlBearerAssertionConfiguration;
    }
}

