/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth;

import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuth2SAMLBearerAssertionTokenServiceContext;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuth2SamlBearerAssertionConfiguration;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuthTokenServiceClient;
import com.sap.core.jpaas.security.saml2.service.SAML2BearerAssertionData;
import com.sap.core.jpaas.security.saml2.service.SAML2BearerGenerationService;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

class OAuth2SamlBearerAssertionTokenServiceClient
extends OAuthTokenServiceClient<String> {
    private static final String OAUTH_GRANT_TYPE_SAML2_BEARER = "urn:ietf:params:oauth:grant-type:saml2-bearer";
    private OAuth2SamlBearerAssertionConfiguration oauthConfiguration;

    OAuth2SamlBearerAssertionTokenServiceClient(OAuth2SAMLBearerAssertionTokenServiceContext oauthContext) {
        super(oauthContext);
        this.oauthConfiguration = oauthContext.getOAuthConfiguration();
    }

    protected String getSAMLAssertion(String userID) throws SAML2Exception, SAML2ConfigurationException {
        String userIdSource;
        String nameIdFormat;
        SAML2BearerAssertionData data = new SAML2BearerAssertionData();
        data.setUserId(userID);
        data.setNameQualifier(this.oauthConfiguration.getUserScopeQualifier());
        data.setRecepientURI(this.oauthConfiguration.getTokenServiceURL());
        data.setAssertionIssuer(this.oauthConfiguration.getAssertionIssuer());
        String authnContextClassRef = this.oauthConfiguration.getAuthnContextClassRef();
        if (authnContextClassRef != null) {
            data.setAuthnContextClassRef(authnContextClassRef);
        }
        if ((nameIdFormat = this.oauthConfiguration.getNameIdFormat()) != null) {
            data.setNameIDFormat(nameIdFormat);
        }
        if ((userIdSource = this.oauthConfiguration.getUserIdSource()) != null) {
            data.setUserIDSource(userIdSource);
        }
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        attributes.put("client_id", Collections.singletonList(this.oauthConfiguration.getClientKey()));
        data.setAttributes(attributes);
        data.setAudience(this.oauthConfiguration.getAudience());
        return SAML2BearerGenerationService.getInstance().generateBearerAsserion(data);
    }

    @Override
    protected String getPostData(String userID) {
        String scope;
        HashMap<String, String> postData = new HashMap<String, String>(5);
        String companyId = this.oauthConfiguration.getCompanyId();
        if (companyId != null) {
            postData.put("company_id", companyId);
        }
        if ((scope = this.oauthConfiguration.getScope()) != null) {
            postData.put("scope", scope);
        }
        postData.put("client_id", this.oauthConfiguration.getClientKey());
        postData.put("grant_type", OAUTH_GRANT_TYPE_SAML2_BEARER);
        try {
            String samlAssertion = this.getSAMLAssertion(userID);
            postData.put("assertion", SAML2Utils.encodeBase64AsString((String)samlAssertion));
        }
        catch (SAML2ConfigurationException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (SAML2Exception ex) {
            throw new IllegalStateException(ex);
        }
        return this.encodePostData(postData);
    }
}

