/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth;

import com.sap.core.connectivity.apiext.impl.cache.ExpiringValue;

class OAuthToken
implements ExpiringValue {
    private static final long DEFAULT_EXPIRATION_INTERVAL = 3600000L;
    private final String token;
    private final long expirationTimeMillis;

    OAuthToken(String token, Long expiresInSeconds) {
        this.token = token;
        this.expirationTimeMillis = this.calculateExpirationTime(expiresInSeconds);
    }

    private long calculateExpirationTime(Long expiresInSeconds) {
        if (expiresInSeconds == null) {
            return System.currentTimeMillis() + 3600000L;
        }
        if (expiresInSeconds <= 0L) {
            return 0L;
        }
        long expirationIntervalMillis = expiresInSeconds * 1000L;
        long expirationTolerance = expirationIntervalMillis / 20L;
        return System.currentTimeMillis() + expirationIntervalMillis - expirationTolerance;
    }

    public String getToken() {
        return this.token;
    }

    public long getExpirationTimeInMillis() {
        return this.expirationTimeMillis;
    }

    @Override
    public boolean hasExpired() {
        return this.expirationTimeMillis <= System.currentTimeMillis();
    }

    public String toString() {
        return String.format("OAuthToken: [%s] ExpirationTimeMillis: [%d]", this.token, this.expirationTimeMillis);
    }
}

