/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth;

import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuthToken;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuthTokenCache;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuthTokenGenerationException;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuthTokenGenerator;
import com.sap.core.connectivity.apiext.impl.cache.AbstractExpiringCache;

class OAuthTokenCacheImpl<T>
extends AbstractExpiringCache<T, OAuthToken>
implements OAuthTokenCache<T> {
    private static final int CACHE_SIZE = 1000;
    private final OAuthTokenGenerator<T> oauthTokenGenerator;

    OAuthTokenCacheImpl(OAuthTokenGenerator<T> oauthTokenGenerator) {
        super(1000);
        this.oauthTokenGenerator = oauthTokenGenerator;
    }

    @Override
    protected OAuthToken generateValueForKey(T currentId) throws OAuthTokenGenerationException {
        return this.oauthTokenGenerator.generateOAuthToken(currentId);
    }
}

