/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth;

import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuthToken;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuthTokenGenerationException;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuthTokenServiceClient;
import java.io.IOException;

class OAuthTokenGenerator<T> {
    private final OAuthTokenServiceClient<T> oauthTokenServiceClient;

    OAuthTokenGenerator(OAuthTokenServiceClient<T> oauthTokenServiceClient) {
        this.oauthTokenServiceClient = oauthTokenServiceClient;
    }

    public OAuthToken generateOAuthToken(T key) throws OAuthTokenGenerationException {
        try {
            return this.oauthTokenServiceClient.retrieveOAuthToken(key);
        }
        catch (IOException ex) {
            throw new OAuthTokenGenerationException("Could not retrieve OAuth 2.0 access token for " + key, ex);
        }
    }
}

