/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.sap.core.connectivity.apiext.impl.BasicConnectivityClient;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuthToken;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuthTokenServiceContext;
import com.sap.core.connectivity.apiext.internal.api.client.BasicOperation;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.log4j.Logger;

abstract class OAuthTokenServiceClient<T>
extends BasicConnectivityClient {
    public static final String LOCATION_ID_HEADER = "SAP-Connectivity-SCC-Location_ID";
    private static final String REQUEST_METHOD = "POST";
    private static final String REQUEST_PROPERTY_CONTENTTYPE = "Content-Type";
    private static final String REQUEST_CONTENTTYPE = "application/x-www-form-urlencoded";
    private static final String RESPONSE_CONTENTTYPE = "application/json";
    private static final Logger log = Logger.getLogger(OAuthTokenServiceClient.class);
    private final String destinationName;
    private final String locationId;

    OAuthTokenServiceClient(OAuthTokenServiceContext oauthContext) {
        super(oauthContext);
        this.destinationName = oauthContext.getConfigurationName();
        this.locationId = oauthContext.getOnPremiseLocationId();
    }

    protected abstract String getPostData(T var1);

    public OAuthToken retrieveOAuthToken(T key) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("OAuth 2.0 Destination '" + this.destinationName + "' :Key " + key + " :Requesting OAuth 2.0 Authorization token from token service '" + this.context.getURL() + "'."));
        }
        final String postData = this.getPostData(key);
        if (log.isDebugEnabled()) {
            log.debug((Object)("OAuth 2.0 Destination '" + this.destinationName + "' :Token service POST parameters:" + postData));
        }
        return (OAuthToken)this.execute(new BasicOperation<OAuthToken>(){

            protected void prepare(HttpURLConnection tokenServiceConnection) throws IOException {
                tokenServiceConnection.setRequestMethod(OAuthTokenServiceClient.REQUEST_METHOD);
                tokenServiceConnection.setRequestProperty(OAuthTokenServiceClient.REQUEST_PROPERTY_CONTENTTYPE, OAuthTokenServiceClient.REQUEST_CONTENTTYPE);
                this.addLocationHeader(tokenServiceConnection);
                tokenServiceConnection.setDoOutput(true);
            }

            protected OAuthToken executeImpl(HttpURLConnection tokenServiceConnection) throws IOException {
                this.sendOAuthTokenRequest(tokenServiceConnection);
                return this.readOAuthTokenResponse(tokenServiceConnection);
            }

            private void sendOAuthTokenRequest(HttpURLConnection tokenServiceConnection) throws IOException {
                try (DataOutputStream tokenServiceOutputStream = new DataOutputStream(tokenServiceConnection.getOutputStream());){
                    tokenServiceOutputStream.writeBytes(postData);
                    tokenServiceOutputStream.flush();
                }
            }

            private OAuthToken readOAuthTokenResponse(HttpURLConnection tokenServiceConnection) throws IOException {
                int responseCode = tokenServiceConnection.getResponseCode();
                String contentType = tokenServiceConnection.getContentType();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("OAuth 2.0 Destination '" + OAuthTokenServiceClient.this.destinationName + "' :Token service response code: " + responseCode));
                    log.debug((Object)("OAuth 2.0 Destination '" + OAuthTokenServiceClient.this.destinationName + "' :Token service response content-type: " + contentType));
                }
                String responseBody = this.readResponse(tokenServiceConnection);
                if (responseCode != 200 || contentType == null || !contentType.contains(OAuthTokenServiceClient.RESPONSE_CONTENTTYPE)) {
                    String errorMessage = String.format("Unexpected response from OAuth token service '%s'\nResponse code: %d\nContent Type: %s\nBody:\n%s", OAuthTokenServiceClient.this.context.getURL(), responseCode, contentType, responseBody);
                    throw new IOException(errorMessage);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("OAuth 2.0 Destination '" + OAuthTokenServiceClient.this.destinationName + "' :Token service response: " + responseBody));
                }
                try {
                    TokenResponse tokenResponse = (TokenResponse)new Gson().fromJson(responseBody, TokenResponse.class);
                    if (tokenResponse == null || tokenResponse.access_token == null || tokenResponse.access_token.isEmpty()) {
                        String errorMessage = String.format("Error getting OAuth token from token service with URL '%s'. Response body: '%s, Token response '%s'", OAuthTokenServiceClient.this.context.getURL(), responseBody, tokenResponse);
                        throw new IOException(errorMessage);
                    }
                    return new OAuthToken(tokenResponse.access_token, tokenResponse.expires_in);
                }
                catch (JsonSyntaxException ex) {
                    String errorMessage = String.format("Error getting OAuth token from token service with URL '%s'. Response body: '%s'", OAuthTokenServiceClient.this.context.getURL(), responseBody);
                    throw new IOException(errorMessage, ex);
                }
            }

            private void addLocationHeader(HttpURLConnection tokenServiceConnection) {
                if (OAuthTokenServiceClient.this.locationId != null && !OAuthTokenServiceClient.this.locationId.trim().isEmpty()) {
                    tokenServiceConnection.setRequestProperty(OAuthTokenServiceClient.LOCATION_ID_HEADER, OAuthTokenServiceClient.this.locationId);
                }
            }
        });
    }

    protected String encodePostData(Map<String, String> postData) {
        try {
            StringBuilder encodedPostData = new StringBuilder();
            boolean firstEntry = true;
            for (Map.Entry<String, String> entry : postData.entrySet()) {
                if (!firstEntry) {
                    encodedPostData.append("&");
                } else {
                    firstEntry = false;
                }
                encodedPostData.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            return encodedPostData.toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static class TokenResponse {
        public String access_token;
        public Long expires_in;

        private TokenResponse() {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TokenResponse [access_token=");
            builder.append(this.access_token);
            builder.append(", expires_in=");
            builder.append(this.expires_in);
            builder.append("]");
            return builder.toString();
        }
    }
}

