/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth;

import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.oauth.OAuth2Configuration;
import com.sap.core.connectivity.apiext.impl.configuration.ConnectivityConfigurationContext;
import com.sap.core.connectivity.apiext.impl.context.AuthContext;
import com.sap.core.connectivity.apiext.impl.context.BasicAuthContext;
import com.sap.core.connectivity.apiext.impl.context.OnPremiseProxyAuthContext;
import com.sap.core.connectivity.apiext.impl.context.ProxyContext;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;

abstract class OAuthTokenServiceContext
extends ConnectivityConfigurationContext {
    OAuthTokenServiceContext(DestinationConfiguration destinationConfiguration) {
        super(destinationConfiguration);
    }

    @Override
    public URL getURL() {
        String url = this.getConfigurationProperty("tokenServiceURL");
        if (this.isOnPremise() && url.startsWith("https://")) {
            url = url.replaceFirst("https", "http");
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public AuthContext getAuthContext() {
        BasicAuthContext authContext = null;
        if (this.isConfigurationPropertyInitialized("tokenServiceUser")) {
            String username = this.getConfigurationProperty("tokenServiceUser");
            String password = this.isConfigurationPropertyInitialized("tokenServicePassword") ? this.getConfigurationProperty("tokenServicePassword") : "";
            authContext = new BasicAuthContext(username, password);
        }
        return authContext;
    }

    public abstract OAuth2Configuration getOAuthConfiguration();

    @Override
    public ProxyContext getProxyContext() {
        if (this.isOnPremise()) {
            String proxyHost = System.getenv("HC_OP_HTTP_PROXY_HOST");
            int proxyPort = Integer.parseInt(System.getenv("HC_OP_HTTP_PROXY_PORT"));
            return new ProxyContext(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort)), new OnPremiseProxyAuthContext());
        }
        return super.getProxyContext();
    }
}

