/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.authentication.assertion.sap;

import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.AbstractAssertionProvider;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.AssertionProviderException;
import com.sap.core.connectivity.apiext.impl.authentication.assertion.sap.SAPAssertionProviderException;
import com.sap.core.jpaas.security.lib.sso2.SSO2TicketFactory;
import com.sap.core.jpaas.security.lib.sso2.TicketException;
import com.sap.engine.lib.xml.util.BASE64Decoder;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import org.apache.log4j.Logger;

public class SAPAssertionProvider
extends AbstractAssertionProvider {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final Logger log = Logger.getLogger(SAPAssertionProvider.class);
    private final String issuerSID;
    private final String issuerClient;
    private final String recipientSID;
    private final String recipientClient;
    private final PrivateKey signingKey;
    private final X509Certificate certificate;

    public SAPAssertionProvider(DestinationConfiguration destinationConfiguration) {
        super(destinationConfiguration.getProperty("SystemUser"));
        this.validateDestinationConfiguration(destinationConfiguration);
        this.issuerSID = destinationConfiguration.getProperty("IssuerSID");
        this.issuerClient = destinationConfiguration.getProperty("IssuerClient");
        this.recipientSID = destinationConfiguration.getProperty("RecipientSID");
        this.recipientClient = destinationConfiguration.getProperty("RecipientClient");
        try {
            this.signingKey = this.getPrivateKey(destinationConfiguration.getProperty("SigningKey"));
            this.certificate = this.getCertificate(destinationConfiguration.getProperty("Certificate"));
        }
        catch (GeneralSecurityException ex) {
            throw this.createAssertionProviderSpecificException(ex.getMessage(), ex);
        }
    }

    protected void validateDestinationConfiguration(DestinationConfiguration destinationConfiguration) {
        String errorMessage = null;
        if ("SAPAssertionSSO".equals(destinationConfiguration.getProperty("Authentication"))) {
            String notSpecifiedProperties = null;
            if (destinationConfiguration.getProperty("IssuerSID") == null) {
                notSpecifiedProperties = "IssuerSID";
            }
            if (destinationConfiguration.getProperty("IssuerClient") == null) {
                String string = notSpecifiedProperties = notSpecifiedProperties == null ? "IssuerClient" : String.valueOf(notSpecifiedProperties) + "," + "IssuerClient";
            }
            if (destinationConfiguration.getProperty("RecipientClient") == null) {
                String string = notSpecifiedProperties = notSpecifiedProperties == null ? "RecipientClient" : String.valueOf(notSpecifiedProperties) + "," + "RecipientClient";
            }
            if (destinationConfiguration.getProperty("RecipientSID") == null) {
                String string = notSpecifiedProperties = notSpecifiedProperties == null ? "RecipientSID" : String.valueOf(notSpecifiedProperties) + "," + "RecipientSID";
            }
            if (destinationConfiguration.getProperty("Certificate") == null) {
                String string = notSpecifiedProperties = notSpecifiedProperties == null ? "Certificate" : String.valueOf(notSpecifiedProperties) + "," + "Certificate";
            }
            if (destinationConfiguration.getProperty("SigningKey") == null) {
                String string = notSpecifiedProperties = notSpecifiedProperties == null ? "SigningKey" : String.valueOf(notSpecifiedProperties) + "," + "SigningKey";
            }
            if (notSpecifiedProperties != null) {
                errorMessage = "Mandatory property(s) " + notSpecifiedProperties + " are not specified.";
            }
        } else {
            errorMessage = "The expected authentication type is 'SAPAssertionSSO'";
        }
        if (errorMessage != null) {
            log.error((Object)errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private PrivateKey getPrivateKey(String privateKeyBase64Encoded) throws NoSuchAlgorithmException {
        KeyFactory keyFactory = KeyFactory.getInstance("DSA");
        try {
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(BASE64Decoder.decode((byte[])privateKeyBase64Encoded.getBytes(CHARSET)));
            return keyFactory.generatePrivate(privateKeySpec);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not generate a private key from a Base64 encoded string." + ex.toString(), ex);
        }
    }

    private X509Certificate getCertificate(String certificateBase64Encoded) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
        try {
            byte[] decoddedCertificate = BASE64Decoder.decode((byte[])certificateBase64Encoded.getBytes(CHARSET));
            return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(decoddedCertificate));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not create a x.509 certificate object from a Base64 encoded string. " + ex.toString(), ex);
        }
    }

    @Override
    protected String getAssertionToken(String userID) {
        try {
            byte[] rawTicket = SSO2TicketFactory.getInstance().createAssertionTicket(this.issuerSID, this.issuerClient, this.recipientSID, this.recipientClient, userID, this.signingKey, this.certificate);
            return new String(BASE64Encoder.encode((byte[])rawTicket), CHARSET);
        }
        catch (TicketException ex) {
            throw new IllegalArgumentException("Invalid key given", ex);
        }
    }

    @Override
    protected AssertionProviderException createAssertionProviderSpecificException(String message) {
        return new SAPAssertionProviderException(message);
    }

    @Override
    protected AssertionProviderException createAssertionProviderSpecificException(Throwable cause) {
        return new SAPAssertionProviderException(cause);
    }

    @Override
    protected AssertionProviderException createAssertionProviderSpecificException(String message, Throwable cause) {
        return new SAPAssertionProviderException(message, cause);
    }

    @Override
    protected String getAssertionType() {
        return "SSO SAP Assertion";
    }
}

