/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.cache;

import com.sap.core.connectivity.apiext.impl.cache.ExpiringCache;
import com.sap.core.connectivity.apiext.impl.cache.ExpiringValue;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public abstract class AbstractExpiringCache<Key, Value extends ExpiringValue>
implements ExpiringCache<Key, Value> {
    private static final Logger log = Logger.getLogger(AbstractExpiringCache.class);
    protected final CacheMap entriesMap = new CacheMap();
    protected final ReadWriteLock mapLock = new ReentrantReadWriteLock(true);
    private final int size;

    protected AbstractExpiringCache(int size) {
        this.size = size;
    }

    @Override
    public Value getValue(Key key) {
        CacheEntry entry = this.getOrCreateEntry(key);
        return entry.getValue();
    }

    private CacheEntry getOrCreateEntry(Key key) {
        this.mapLock.readLock().lock();
        try {
            CacheEntry entry = (CacheEntry)this.entriesMap.get(key);
            if (entry == null) {
                entry = this.createNewEntry(key);
            }
            CacheEntry cacheEntry = entry;
            return cacheEntry;
        }
        finally {
            this.mapLock.readLock().unlock();
        }
    }

    private CacheEntry createNewEntry(Key key) {
        this.mapLock.readLock().unlock();
        this.mapLock.writeLock().lock();
        try {
            CacheEntry entry = (CacheEntry)this.entriesMap.get(key);
            if (entry != null) {
                CacheEntry cacheEntry = entry;
                return cacheEntry;
            }
            entry = new CacheEntry(key);
            this.entriesMap.put(key, entry);
            CacheEntry cacheEntry = entry;
            return cacheEntry;
        }
        finally {
            this.mapLock.readLock().lock();
            this.mapLock.writeLock().unlock();
        }
    }

    @Override
    public boolean hasExpired() {
        this.mapLock.writeLock().lock();
        try {
            this.entriesMap.cleanExpiredEntries();
            boolean bl = this.entriesMap.isEmpty();
            return bl;
        }
        finally {
            this.mapLock.writeLock().unlock();
        }
    }

    protected abstract Value generateValueForKey(Key var1);

    @Override
    public int size() {
        return this.entriesMap.size();
    }

    private class CacheEntry {
        private ReadWriteLock entryLock;
        private Key key;
        private Value value;

        CacheEntry(Key key) {
            if (key == null) {
                throw new IllegalArgumentException("Cannot create entry with no key!");
            }
            this.entryLock = new ReentrantReadWriteLock(true);
            this.key = key;
            this.value = null;
        }

        private void generateValue() {
            this.entryLock.readLock().unlock();
            this.entryLock.writeLock().lock();
            try {
                if (this.value == null || this.hasExpired()) {
                    this.value = AbstractExpiringCache.this.generateValueForKey(this.key);
                }
            }
            finally {
                this.entryLock.readLock().lock();
                this.entryLock.writeLock().unlock();
            }
        }

        public Value getValue() {
            this.entryLock.readLock().lock();
            try {
                if (this.value == null || this.hasExpired()) {
                    this.generateValue();
                }
                Object Value = this.value;
                return Value;
            }
            finally {
                this.entryLock.readLock().unlock();
            }
        }

        private boolean hasExpired() {
            if (this.entryLock.readLock().tryLock()) {
                try {
                    if (this.value == null) {
                        return true;
                    }
                    boolean bl = this.value.hasExpired();
                    return bl;
                }
                finally {
                    this.entryLock.readLock().unlock();
                }
            }
            return false;
        }

        public String toString() {
            return String.format("%s: Key [%s], Value [%s]", this.getClass().getSimpleName(), this.key, this.value);
        }
    }

    private class CacheMap
    extends LinkedHashMap<Key, CacheEntry> {
        private CacheMap() {
        }

        @Override
        public CacheEntry put(Key key, CacheEntry newEntry) {
            this.cleanExpiredEntries();
            CacheEntry oldEntry = super.put(key, newEntry);
            if (log.isDebugEnabled()) {
                if (oldEntry != null) {
                    log.debug((Object)String.format("New entry added. Old entry removed: %s", oldEntry));
                }
                log.debug((Object)String.format("New entry put: %s", newEntry));
            }
            return oldEntry;
        }

        private void cleanExpiredEntries() {
            try {
                int removedEntries = 0;
                Iterator iterator = this.entrySet().iterator();
                while (iterator.hasNext()) {
                    CacheEntry entry = (CacheEntry)iterator.next().getValue();
                    if (!entry.hasExpired()) continue;
                    iterator.remove();
                    ++removedEntries;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("Removed entry: %s", entry));
                }
                if (removedEntries > 0 && log.isDebugEnabled()) {
                    log.debug((Object)String.format("Removed %d stale entries from cache", removedEntries));
                }
            }
            catch (Exception ex) {
                log.error((Object)"Problem clearing the expired entries!", (Throwable)ex);
            }
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Key, CacheEntry> eldest) {
            return this.size() > AbstractExpiringCache.this.size;
        }
    }
}

