/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.cache;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class CircuitBreakerFutureExecutor {
    private final AtomicLong lastIOExceptionTimeMillis = new AtomicLong();
    private final long period;
    private volatile IOException circuitBrakeException;

    public CircuitBreakerFutureExecutor(long period, TimeUnit timeUnit) {
        this.period = timeUnit.toMillis(period);
    }

    public <V> V execute(Callable<V> task) throws Exception {
        long lastTime;
        long ioExceptionTimeWait;
        long currentTime = System.currentTimeMillis();
        if (currentTime > (ioExceptionTimeWait = (lastTime = this.lastIOExceptionTimeMillis.get()) + this.period)) {
            try {
                return task.call();
            }
            catch (Exception ex) {
                if (ex instanceof IOException) {
                    IOException cause = (IOException)ex;
                    if (this.lastIOExceptionTimeMillis.compareAndSet(lastTime, System.currentTimeMillis())) {
                        this.circuitBrakeException = cause;
                    }
                }
                throw ex;
            }
        }
        while (this.circuitBrakeException == null) {
        }
        throw this.circuitBrakeException;
    }
}

