/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.cache;

import com.sap.core.connectivity.apiext.impl.configuration.ConfigurationLevel;
import com.sap.core.connectivity.apiext.impl.util.Optional;

public final class ConfigurationKey {
    private final String configurationName;
    private final Optional<ConfigurationLevel> configurationLevel;
    private final Optional<String> tenantId;

    public ConfigurationKey(String configurationName) {
        this(configurationName, null, null);
    }

    public ConfigurationKey(String configurationName, ConfigurationLevel configurationLevel) {
        this(configurationName, configurationLevel, null);
    }

    public ConfigurationKey(String configurationName, ConfigurationLevel configurationLevel, String tenantId) {
        assert (configurationName != null);
        this.configurationName = configurationName;
        this.configurationLevel = Optional.fromNullable(configurationLevel);
        this.tenantId = Optional.fromNullable(tenantId);
    }

    public Optional<ConfigurationLevel> getConfigurationLevel() {
        return this.configurationLevel;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public Optional<String> getTenantId() {
        return this.tenantId;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.configurationName == null ? 0 : this.configurationName.hashCode());
        result = 31 * result + (this.configurationLevel == null ? 0 : this.configurationLevel.hashCode());
        result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationKey other = (ConfigurationKey)obj;
        if (this.configurationName == null ? other.configurationName != null : !this.configurationName.equals(other.configurationName)) {
            return false;
        }
        if (this.configurationLevel == null ? other.configurationLevel != null : !this.configurationLevel.equals(other.configurationLevel)) {
            return false;
        }
        return !(this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId));
    }

    public String toString() {
        return "DestinationKey [configurationName=" + this.configurationName + ", level=" + this.configurationLevel + ", tenantId=" + this.tenantId + "]";
    }
}

