/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.cache;

import com.sap.core.connectivity.apiext.impl.cache.CircuitBreakerFutureExecutor;
import com.sap.core.connectivity.apiext.impl.cache.ConfigurationKey;
import com.sap.core.connectivity.apiext.impl.cache.DataSourceCache;
import com.sap.core.connectivity.apiext.impl.cache.util.Computable;
import com.sap.core.connectivity.apiext.impl.cache.util.Memoizer;
import com.sap.core.connectivity.apiext.impl.cache.util.PeriodicFutureExecutor;
import com.sap.core.connectivity.apiext.impl.cache.util.PeriodicMemoizer;
import com.sap.core.connectivity.apiext.impl.configuration.ConfigurationLevel;
import com.sap.core.connectivity.apiext.impl.datasource.DataSource;
import com.sap.core.connectivity.apiext.impl.datasource.object.DestinationConfigurationObject;
import com.sap.core.connectivity.apiext.impl.datasource.object.KeystoreConfigurationObject;
import com.sap.core.connectivity.apiext.impl.util.Optional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class DataSourceCacheImpl
implements DataSourceCache {
    private static final Logger log = Logger.getLogger(DataSourceCacheImpl.class);
    private static final long DEFAULT_REFRESH_TIMEOUT_INTERVAL_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private final Memoizer<ConfigurationKey, DestinationConfigurationObject> destinationsMemoizer;
    private final Memoizer<ConfigurationKey, KeystoreConfigurationObject> keystoreMemoizer;
    private final Memoizer<String, List<ConfigurationKey>> tenantDestinationsMemoizer;
    private final Memoizer<String, String> defaultTenantIdForAccountMemoizer;
    private final long refreshIntervalMillis;
    private final CircuitBreakerFutureExecutor circuitBreakerFutureExecutor;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();

    public DataSourceCacheImpl(DataSource dataSource) {
        this(dataSource, DEFAULT_REFRESH_TIMEOUT_INTERVAL_MILLIS);
    }

    public DataSourceCacheImpl(DataSource dataSource, long refreshIntervalMillis) {
        this.refreshIntervalMillis = refreshIntervalMillis;
        this.circuitBreakerFutureExecutor = new CircuitBreakerFutureExecutor(refreshIntervalMillis, TimeUnit.MILLISECONDS);
        Computable<ConfigurationKey, DestinationConfigurationObject> destinationRetryingComputable = this.createDestinationComputable(dataSource);
        this.destinationsMemoizer = this.createDataSourceMemoizer(destinationRetryingComputable);
        Computable<ConfigurationKey, KeystoreConfigurationObject> keystoreRetryingComputable = this.createKeystoreComputable(dataSource);
        this.keystoreMemoizer = this.createDataSourceMemoizer(keystoreRetryingComputable);
        Computable<String, List<ConfigurationKey>> tenantDestinationsRetryingComputable = this.createTenantDestinationsComputable(dataSource);
        this.tenantDestinationsMemoizer = this.createDataSourceMemoizer(tenantDestinationsRetryingComputable);
        Computable<String, String> defaultTenantIdRetryingComputable = this.createDefaultTenantIdComputable(dataSource);
        this.defaultTenantIdForAccountMemoizer = this.createDataSourceMemoizer(defaultTenantIdRetryingComputable);
    }

    protected <K, V> Memoizer<K, V> createDataSourceMemoizer(Computable<K, V> computable) {
        return this.createDataSourceMemoizer(computable, this.refreshIntervalMillis, TimeUnit.MILLISECONDS);
    }

    protected <K, V> PeriodicMemoizer<K, V> createDataSourceMemoizer(Computable<K, V> computable, long period, TimeUnit timeUnit) {
        return new DatasourceMemoizer<K, V>(computable, period, timeUnit, this.circuitBreakerFutureExecutor);
    }

    private Computable<ConfigurationKey, DestinationConfigurationObject> createDestinationComputable(final DataSource dataSource) {
        return new Computable<ConfigurationKey, DestinationConfigurationObject>(){

            @Override
            public Optional<DestinationConfigurationObject> compute(ConfigurationKey key) throws IOException {
                if (key.getTenantId().isPresent() && key.getConfigurationLevel().isPresent() && key.getConfigurationLevel().get() == ConfigurationLevel.TENANT) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("[%s] Will get destination with name [%s] and tenant [%s]", this.toString(), key.getConfigurationName(), key.getTenantId()));
                    }
                    return dataSource.getDestinationConfiguration(key.getTenantId().get(), key.getConfigurationName());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("[%s] Will get destination with name [%s]", this.toString(), key.getConfigurationName()));
                }
                return dataSource.getDestinationConfiguration(key.getConfigurationName());
            }

            public String toString() {
                return "DestinationMemoizerComputable";
            }
        };
    }

    private Computable<String, List<ConfigurationKey>> createTenantDestinationsComputable(final DataSource dataSource) {
        return new Computable<String, List<ConfigurationKey>>(){

            @Override
            public Optional<List<ConfigurationKey>> compute(String tenantId) throws IOException {
                Optional<List<DestinationConfigurationObject>> destinationConfigurations;
                ArrayList<ConfigurationKey> destinationConfigurationKeys = null;
                Optional<List<DestinationConfigurationObject>> optional = destinationConfigurations = tenantId != null ? dataSource.getDestinationConfigurations(tenantId) : dataSource.getDestinationConfigurations();
                if (destinationConfigurations.isPresent()) {
                    destinationConfigurationKeys = new ArrayList<ConfigurationKey>(destinationConfigurations.get().size());
                    for (DestinationConfigurationObject destinationConfiguration : destinationConfigurations.get()) {
                        String configurationName = destinationConfiguration.getProperties().getProperty("Name");
                        if (configurationName != null && !configurationName.isEmpty()) {
                            ConfigurationKey destinationConfigurationKey = new ConfigurationKey(configurationName, ConfigurationLevel.TENANT, tenantId);
                            DataSourceCacheImpl.this.destinationsMemoizer.injectIfAbsent(destinationConfigurationKey, destinationConfiguration);
                            destinationConfigurationKeys.add(destinationConfigurationKey);
                            continue;
                        }
                        log.error((Object)("Destination without name found: " + destinationConfiguration.getProperties()));
                    }
                }
                return Optional.fromNullable(destinationConfigurationKeys);
            }

            public String toString() {
                return "TenantDestinationsMemoizerComputable";
            }
        };
    }

    private Computable<ConfigurationKey, KeystoreConfigurationObject> createKeystoreComputable(final DataSource dataSource) {
        return new Computable<ConfigurationKey, KeystoreConfigurationObject>(){

            @Override
            public Optional<KeystoreConfigurationObject> compute(ConfigurationKey key) throws IOException {
                if (key.getTenantId().isPresent() && key.getConfigurationLevel().get() == ConfigurationLevel.TENANT) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("[%s] Will get keystore with name [%s] and tenant [%s]", this.toString(), key.getConfigurationName(), key.getTenantId()));
                    }
                    return dataSource.getKeystoreConfiguration(key.getTenantId().get(), key.getConfigurationName());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("[%s] Will get keystore with name [%s]", this.toString(), key.getConfigurationName()));
                }
                return dataSource.getKeystoreConfiguration(key.getConfigurationName(), key.getConfigurationLevel().get());
            }

            public String toString() {
                return "KeystoreMemoizerComputable";
            }
        };
    }

    private Computable<String, String> createDefaultTenantIdComputable(final DataSource dataSource) {
        return new Computable<String, String>(){

            @Override
            public Optional<String> compute(String accountName) throws IOException {
                return Optional.of(dataSource.getDefaultTenantId(accountName));
            }

            public String toString() {
                return "DefaultTenantIdMemoizerComputable";
            }
        };
    }

    @Override
    public Optional<DestinationConfigurationObject> getDestinationConfiguration(String name) throws IOException {
        ConfigurationKey key = new ConfigurationKey(name);
        return this.getDestinationConfiguration(key);
    }

    @Override
    public Optional<DestinationConfigurationObject> getDestinationConfiguration(String tenantId, String name) throws IOException {
        ConfigurationKey key = new ConfigurationKey(name, ConfigurationLevel.TENANT, tenantId);
        return this.getDestinationConfiguration(key);
    }

    protected Optional<DestinationConfigurationObject> getDestinationConfiguration(ConfigurationKey key) throws IOException {
        return this.computeFromMemoizer(this.destinationsMemoizer, key);
    }

    @Override
    public Optional<List<DestinationConfigurationObject>> getDestinationConfigurations() throws IOException {
        return this.getDestinationConfigurations(null);
    }

    @Override
    public Optional<List<DestinationConfigurationObject>> getDestinationConfigurations(String tenantId) throws IOException {
        ArrayList<DestinationConfigurationObject> destinationConfigurations = null;
        this.readLock.lock();
        try {
            Optional<List<ConfigurationKey>> configurationKeys = this.computeFromMemoizer(this.tenantDestinationsMemoizer, tenantId);
            if (configurationKeys.isPresent()) {
                destinationConfigurations = new ArrayList<DestinationConfigurationObject>(configurationKeys.get().size());
                for (ConfigurationKey key : configurationKeys.get()) {
                    Optional<DestinationConfigurationObject> destinationConfiguration = this.getDestinationConfiguration(key);
                    if (!destinationConfiguration.isPresent()) continue;
                    destinationConfigurations.add(destinationConfiguration.get());
                }
                if (destinationConfigurations.isEmpty()) {
                    Optional<List<DestinationConfigurationObject>> optional = Optional.absent();
                    return optional;
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
        return Optional.fromNullable(destinationConfigurations);
    }

    @Override
    public Optional<KeystoreConfigurationObject> getKeystoreConfiguration(String name, ConfigurationLevel level) throws IOException {
        ConfigurationKey key = new ConfigurationKey(name, level);
        return this.getKeystoreConfiguration(key);
    }

    @Override
    public Optional<KeystoreConfigurationObject> getKeystoreConfiguration(String tenantId, String name) throws IOException {
        ConfigurationKey key = new ConfigurationKey(name, ConfigurationLevel.TENANT, tenantId);
        return this.getKeystoreConfiguration(key);
    }

    protected Optional<KeystoreConfigurationObject> getKeystoreConfiguration(ConfigurationKey key) throws IOException {
        return this.computeFromMemoizer(this.keystoreMemoizer, key);
    }

    @Override
    public String getDefaultTenantId(String accountName) throws IOException {
        return this.computeFromMemoizer(this.defaultTenantIdForAccountMemoizer, accountName).get();
    }

    protected <T, U> Optional<U> computeFromMemoizer(Memoizer<T, U> cache, T key) throws IOException {
        try {
            return cache.compute(key);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Object)"Unexpected exception type, should not happen", (Throwable)ex);
        }
        return Optional.absent();
    }

    @Override
    public void clearCache() {
        this.clearCache(new MemoizerClearer(){

            @Override
            public void clear(Memoizer<?, ?> m) {
                m.clear();
            }
        });
    }

    protected void clearCache(MemoizerClearer mc) {
        this.writeLock.lock();
        try {
            mc.clear(this.destinationsMemoizer);
            mc.clear(this.tenantDestinationsMemoizer);
        }
        finally {
            this.writeLock.unlock();
        }
        mc.clear(this.keystoreMemoizer);
        mc.clear(this.defaultTenantIdForAccountMemoizer);
    }

    public static class DataSourceFutureExecutor<V>
    extends PeriodicFutureExecutor<V> {
        public DataSourceFutureExecutor(Callable<V> task, long period, TimeUnit timeUnit) {
            super(task, period, timeUnit);
        }

        public DataSourceFutureExecutor(Callable<V> task, long period, TimeUnit timeUnit, V initialValue) {
            super(task, period, timeUnit, initialValue);
        }

        @Override
        protected boolean shouldUpdateValue(ExecutionException ex) {
            return !(ex.getCause() instanceof IOException);
        }
    }

    public static class DatasourceMemoizer<K, V>
    extends PeriodicMemoizer<K, V> {
        private final CircuitBreakerFutureExecutor circuitBreakerFutureExecutor;

        public DatasourceMemoizer(Computable<K, V> c, long period, TimeUnit timeUnit, CircuitBreakerFutureExecutor circuitBreakerFutureExecutor) {
            super(c, period, timeUnit);
            this.circuitBreakerFutureExecutor = circuitBreakerFutureExecutor;
        }

        @Override
        public DataSourceFutureExecutor<Optional<V>> createFutureExecutor(K key, V value) {
            final Callable task = this.createTask(key);
            return new DataSourceFutureExecutor<Optional<V>>(new Callable<Optional<V>>(){

                @Override
                public Optional<V> call() throws Exception {
                    return (Optional)DatasourceMemoizer.this.circuitBreakerFutureExecutor.execute(task);
                }
            }, this.period, this.timeUnit, Optional.fromNullable(value));
        }

        @Override
        public DataSourceFutureExecutor<Optional<V>> createFutureExecutor(final Callable<Optional<V>> task) {
            return new DataSourceFutureExecutor<Optional<V>>(new Callable<Optional<V>>(){

                @Override
                public Optional<V> call() throws Exception {
                    return (Optional)DatasourceMemoizer.this.circuitBreakerFutureExecutor.execute(task);
                }
            }, this.period, this.timeUnit);
        }
    }

    protected static interface MemoizerClearer {
        public void clear(Memoizer<?, ?> var1);
    }
}

