/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.cache.util;

import com.sap.core.connectivity.apiext.impl.cache.util.FutureExecutor;
import com.sap.core.connectivity.apiext.impl.cache.util.ValueFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultFutureExecutor<V>
implements FutureExecutor<V> {
    private final RunnableFuture<V> future;
    private final AtomicBoolean executed;

    public DefaultFutureExecutor(Callable<V> task) {
        this.future = new FutureTask<V>(task);
        this.executed = new AtomicBoolean(false);
    }

    public DefaultFutureExecutor(V value) {
        this.future = new ValueFuture<V>(value);
        this.executed = new AtomicBoolean(true);
    }

    @Override
    public V execute() throws InterruptedException, ExecutionException {
        if (this.executed.compareAndSet(false, true)) {
            this.future.run();
        }
        return this.future.get();
    }
}

