/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.cache.util;

import com.sap.core.connectivity.apiext.impl.cache.util.Computable;
import com.sap.core.connectivity.apiext.impl.cache.util.DefaultFutureExecutor;
import com.sap.core.connectivity.apiext.impl.cache.util.FutureExecutor;
import com.sap.core.connectivity.apiext.impl.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;

public class Memoizer<K, V>
implements Computable<K, V> {
    private static final Logger logger = Logger.getLogger(Memoizer.class);
    private final ConcurrentMap<K, FutureExecutor<Optional<V>>> cache = new ConcurrentHashMap<K, FutureExecutor<Optional<V>>>();
    private final Computable<K, V> c;

    public Memoizer(Computable<K, V> c) {
        assert (c != null);
        this.c = c;
    }

    public final void injectIfAbsent(K key, V value) {
        this.cache.putIfAbsent(key, this.createFutureExecutor(key, value));
    }

    public final Optional<V> getIfMemoized(K key) {
        FutureExecutor cachedFutureExecutor = (FutureExecutor)this.cache.get(key);
        try {
            if (cachedFutureExecutor != null) {
                return (Optional)cachedFutureExecutor.execute();
            }
        }
        catch (Exception ex) {
            if (ex instanceof ExecutionException) {
                this.remove(key, cachedFutureExecutor);
            }
            logger.error((Object)String.format("An exception happened while retrieving memoized value for key %s, absent returned.", key.toString()), (Throwable)ex);
        }
        return Optional.absent();
    }

    @Override
    public final Optional<V> compute(K key) throws InterruptedException, Exception {
        FutureExecutor<Optional<Optional<V>>> futureExecutor;
        FutureExecutor<Optional<V>> cachedFutureExecutor = (FutureExecutor<Optional<V>>)this.cache.get(key);
        if (cachedFutureExecutor == null && (cachedFutureExecutor = this.cache.putIfAbsent(key, futureExecutor = this.createFutureExecutor(key))) == null) {
            cachedFutureExecutor = futureExecutor;
        }
        try {
            return (Optional)cachedFutureExecutor.execute();
        }
        catch (ExecutionException ex) {
            this.remove(key, cachedFutureExecutor);
            throw this.processExecutionException(ex);
        }
    }

    public final void clear() {
        this.cache.clear();
    }

    protected final void remove(K key, FutureExecutor<Optional<V>> futureExecutor) {
        this.cache.remove(key, futureExecutor);
    }

    protected final Exception processExecutionException(ExecutionException ex) throws Error {
        Throwable cause = ex.getCause();
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        return (Exception)cause;
    }

    protected final Callable<Optional<V>> createTask(final K key) {
        return new Callable<Optional<V>>(){

            @Override
            public Optional<V> call() throws Exception {
                return Memoizer.this.c.compute(key);
            }

            public String toString() {
                return String.format("Memoizer task with key=<%s, %s>", Memoizer.this.c.toString(), key.toString());
            }
        };
    }

    protected FutureExecutor<Optional<V>> createFutureExecutor(K key) {
        Callable<Optional<V>> task = this.createTask(key);
        return this.createFutureExecutor(task);
    }

    protected FutureExecutor<Optional<V>> createFutureExecutor(K key, V value) {
        return new DefaultFutureExecutor<Optional<V>>(Optional.fromNullable(value));
    }

    protected FutureExecutor<Optional<V>> createFutureExecutor(Callable<Optional<V>> task) {
        return new DefaultFutureExecutor<Callable<Optional<V>>>(task);
    }
}

