/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.cache.util;

import com.sap.core.connectivity.apiext.impl.cache.util.FutureExecutor;
import com.sap.core.connectivity.apiext.impl.cache.util.ValueFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public class PeriodicFutureExecutor<V>
implements FutureExecutor<V> {
    private static final Logger logger = Logger.getLogger(PeriodicFutureExecutor.class);
    private final Callable<V> task;
    private final long executionPeriodMillis;
    private final AtomicLong lastExecutionTimeMillis;
    private final AtomicReference<RunnableFuture<V>> futureReference;
    private final AtomicBoolean cacheEnabled = new AtomicBoolean(false);

    public PeriodicFutureExecutor(Callable<V> task, long period, TimeUnit timeUnit) {
        this.task = task;
        this.executionPeriodMillis = timeUnit.toMillis(period);
        this.lastExecutionTimeMillis = new AtomicLong(0L);
        FutureTask<V> future = new FutureTask<V>(task);
        this.futureReference = new AtomicReference<FutureTask<RunnableFuture<V>>>(future);
    }

    public PeriodicFutureExecutor(Callable<V> task, long period, TimeUnit timeUnit, V initialValue) {
        this.task = task;
        this.executionPeriodMillis = timeUnit.toMillis(period);
        this.lastExecutionTimeMillis = new AtomicLong(System.currentTimeMillis());
        ValueFuture<V> future = new ValueFuture<V>(initialValue);
        this.futureReference = new AtomicReference<ValueFuture<RunnableFuture<V>>>(future);
    }

    @Override
    public V execute() throws InterruptedException, ExecutionException {
        long time = System.currentTimeMillis();
        long lastTime = this.lastExecutionTimeMillis.get();
        if ((lastTime == 0L || time > lastTime + this.executionPeriodMillis) && this.lastExecutionTimeMillis.compareAndSet(lastTime, time)) {
            this.runTask(lastTime == 0L);
        }
        return this.futureReference.get().get();
    }

    private void runTask(boolean firstTime) throws InterruptedException {
        RunnableFuture<V> future = this.futureReference.get();
        if (firstTime) {
            future.run();
        } else {
            FutureTask<V> newFuture = new FutureTask<V>(this.task);
            newFuture.run();
            boolean updateFuture = true;
            ExecutionException executionException = null;
            try {
                newFuture.get();
            }
            catch (ExecutionException ex) {
                updateFuture = this.shouldUpdateValue(ex);
                executionException = ex;
            }
            if (updateFuture && this.futureReference.compareAndSet(future, newFuture)) {
                if (this.cacheEnabled.compareAndSet(true, false)) {
                    logger.warn((Object)String.format("The value for %s is updated successfully, the cache is disabled", this.task.toString()));
                }
            } else if (updateFuture) {
                logger.warn((Object)String.format("The value for %s was updated by another thread meanwhile", this.task.toString()));
            } else if (future == this.futureReference.get() && this.cacheEnabled.compareAndSet(false, true)) {
                logger.warn((Object)String.format("The period time expired for %s, but the value is not updated because of an exception. Try to update the value again at most within %s nanoseconds, the cache is enabled", this.task.toString(), this.executionPeriodMillis), executionException.getCause());
            }
        }
    }

    protected boolean shouldUpdateValue(ExecutionException ex) {
        return true;
    }
}

