/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.configuration;

import com.sap.core.connectivity.api.configuration.ConnectivityConfiguration;
import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.apiext.impl.configuration.DestinationConfigurationException;
import com.sap.core.connectivity.apiext.impl.configuration.DestinationNotAvailableException;
import com.sap.core.connectivity.apiext.impl.configuration.provider.ConfigurationProvider;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractConnectivityConfiguration
implements ConnectivityConfiguration {
    private static final Logger log = Logger.getLogger(AbstractConnectivityConfiguration.class);
    protected final ConfigurationProvider provider;

    public AbstractConnectivityConfiguration(ConfigurationProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("ConfigurationProvider missing");
        }
        this.provider = provider;
    }

    public ConfigurationProvider getConfigurationProvider() {
        return this.provider;
    }

    public DestinationConfiguration getConfiguration(String name) {
        return this.getConfiguration(this.provider, name);
    }

    protected DestinationConfiguration getConfiguration(ConfigurationProvider configurationProvider, String name) {
        try {
            return configurationProvider.getDestinationConfiguration(name);
        }
        catch (DestinationNotAvailableException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)ex);
            }
        }
        catch (DestinationConfigurationException ex) {
            throw new IllegalStateException("Problem while retrieving configuration", ex);
        }
        return null;
    }

    protected Map<String, DestinationConfiguration> getConfigurations(ConfigurationProvider configurationProvider) {
        try {
            return configurationProvider.getDestinationConfigurations();
        }
        catch (DestinationNotAvailableException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)ex);
            }
        }
        catch (DestinationConfigurationException ex) {
            throw new IllegalStateException("Problem while retrieving configurations", ex);
        }
        return null;
    }
}

