/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.configuration;

import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.apiext.impl.configuration.ConfigurationLevel;
import com.sap.core.connectivity.apiext.impl.configuration.DestinationConfigurationException;
import com.sap.core.connectivity.apiext.impl.configuration.DestinationNotAvailableException;
import com.sap.core.connectivity.apiext.impl.configuration.PropertiesUtil;
import com.sap.core.connectivity.apiext.impl.keystore.KeyStoreFactory;
import com.sap.core.connectivity.apiext.impl.keystore.KeyStoreUtil;
import com.sap.core.connectivity.apiext.impl.ldap.LdapDestinationUtil;
import java.security.KeyStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class AbstractDestinationConfiguration
implements DestinationConfiguration {
    private final Logger logger = Logger.getLogger(AbstractDestinationConfiguration.class);
    private final Map<String, String> propertiesMap = new HashMap<String, String>();
    private final ConfigurationLevel configurationLevel;
    protected final KeyStoreFactory keyStoreFactory;

    public AbstractDestinationConfiguration(Properties configurationProperties, ConfigurationLevel configurationLevel, KeyStoreFactory keyStoreFactory) {
        if (configurationProperties == null) {
            throw new IllegalArgumentException("configurationProperties can not be null");
        }
        Properties enhancedProperties = AbstractDestinationConfiguration.enhanceProperties(configurationProperties, keyStoreFactory);
        for (String key : enhancedProperties.stringPropertyNames()) {
            this.propertiesMap.put(key, enhancedProperties.getProperty(key));
        }
        this.keyStoreFactory = keyStoreFactory;
        this.configurationLevel = configurationLevel;
    }

    private static Properties enhanceProperties(Properties destinationProperties, KeyStoreFactory keystoreFactory) {
        Properties enhancedProperties = AbstractDestinationConfiguration.enhanceOnPremiseProperties(destinationProperties);
        enhancedProperties = AbstractDestinationConfiguration.enhanceLDAPContextProperties(enhancedProperties);
        return AbstractDestinationConfiguration.setVMKeystoreAndTruststorePassword(enhancedProperties, keystoreFactory);
    }

    private static Properties enhanceOnPremiseProperties(Properties destinationProperties) {
        return destinationProperties;
    }

    private static Properties enhanceLDAPContextProperties(Properties destinationProperties) {
        if (LdapDestinationUtil.isLdapDestination(destinationProperties)) {
            return LdapDestinationUtil.convertToLDAPContextProperties(destinationProperties);
        }
        return destinationProperties;
    }

    private static Properties setVMKeystoreAndTruststorePassword(Properties properties, KeyStoreFactory keystoreFactory) {
        Properties enhancedProperties = properties;
        if ("InternalSystemAuthentication".equals(properties.getProperty("Authentication"))) {
            String vmPassword = keystoreFactory.getVmKeystoreAndTruststorePassword();
            enhancedProperties = PropertiesUtil.copyProperties(properties);
            enhancedProperties.put("KeyStorePassword", vmPassword);
            enhancedProperties.put("TrustStorePassword", vmPassword);
        }
        return enhancedProperties;
    }

    public KeyStore getKeyStore() {
        if ("InternalSystemAuthentication".equals(this.getProperty("Authentication"))) {
            return this.getInternalSystemKeyStore();
        }
        String keyStoreLocation = this.getProperty("KeyStoreLocation");
        String keyStorePassword = this.getProperty("KeyStorePassword");
        return this.getKeyStore(keyStoreLocation, keyStorePassword);
    }

    private KeyStore getInternalSystemKeyStore() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Internal system authentication is determined and VM keystore will be used for destination %s", this.getProperty("Name")));
        }
        return this.keyStoreFactory.createVmKeystore();
    }

    public KeyStore getTrustStore() {
        if ("InternalSystemAuthentication".equals(this.getProperty("Authentication"))) {
            return this.getInternalSystemTrustStore();
        }
        String trustStoreLocation = this.getProperty("TrustStoreLocation");
        String trustStorePassword = this.getProperty("TrustStorePassword");
        if (trustStoreLocation == null) {
            return this.keyStoreFactory.createJDKTruststore();
        }
        KeyStore trustStore = this.getKeyStore(trustStoreLocation, trustStorePassword);
        if (trustStore != null) {
            KeyStore jdkTrustStore = this.keyStoreFactory.createJDKTruststore();
            try {
                trustStore = KeyStoreUtil.mergeTrustStores(jdkTrustStore, trustStore);
            }
            catch (Exception ex) {
                this.logger.error((Object)"JDK and specified trust store cannot be merged", (Throwable)ex);
                throw new IllegalStateException("JDK and specified trust store cannot be merged");
            }
        }
        return trustStore;
    }

    private KeyStore getInternalSystemTrustStore() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Internal system authentication is determined and VM truststore will be used for destination %s", this.getProperty("Name")));
        }
        KeyStore vmTrustStore = this.keyStoreFactory.createVmTruststore();
        KeyStore jdkTrustStore = this.keyStoreFactory.createJDKTruststore();
        try {
            return KeyStoreUtil.mergeTrustStores(jdkTrustStore, vmTrustStore);
        }
        catch (Exception ex) {
            this.logger.error((Object)"JDK and VM trust store cannot be merged", (Throwable)ex);
            throw new IllegalStateException("JDK and VM trust store cannot be merged");
        }
    }

    private KeyStore getKeyStore(String keyStoreLocation, String keyStorePassword) {
        KeyStore keyStore = null;
        if (keyStoreLocation != null && !keyStoreLocation.isEmpty()) {
            try {
                keyStore = this.loadKeyStore(keyStoreLocation, keyStorePassword);
            }
            catch (DestinationNotAvailableException ex) {
                this.logger.debug((Object)ex);
            }
            catch (DestinationConfigurationException ex) {
                throw new IllegalStateException("Problem while retrieving keystore", ex);
            }
        }
        return keyStore;
    }

    protected abstract KeyStore loadKeyStore(String var1, String var2) throws DestinationConfigurationException;

    public String getProperty(String key) {
        return this.propertiesMap.get(key);
    }

    public Map<String, String> getAllProperties() {
        return Collections.unmodifiableMap(this.propertiesMap);
    }

    public ConfigurationLevel getConfigurationLevel() {
        return this.configurationLevel;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.propertiesMap.hashCode();
        result = 31 * result + (this.configurationLevel == null ? 0 : this.configurationLevel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDestinationConfiguration other = (AbstractDestinationConfiguration)obj;
        if (!this.propertiesMap.equals(other.propertiesMap)) {
            return false;
        }
        return !(this.configurationLevel == null ? other.configurationLevel != null : !this.configurationLevel.equals((Object)other.configurationLevel));
    }

    public String toString() {
        return String.format("DestinationConfiguration name: %s Configuration Level: %s", new Object[]{this.propertiesMap.get("Name"), this.configurationLevel});
    }
}

