/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.configuration;

import java.util.HashMap;
import java.util.Map;

public enum ConfigurationLevel {
    APPLICATION("Application"),
    SUBSCRIPTION("Subscription"),
    TENANT("Account"),
    FILESYSTEM("FileSystem");

    private static final Map<String, ConfigurationLevel> stringToEnum;
    private final String value;

    static {
        stringToEnum = new HashMap<String, ConfigurationLevel>();
        ConfigurationLevel[] configurationLevelArray = ConfigurationLevel.values();
        int n = configurationLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationLevel level = configurationLevelArray[n2];
            stringToEnum.put(level.toString(), level);
            ++n2;
        }
    }

    private ConfigurationLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static ConfigurationLevel getValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null.");
        }
        if (stringToEnum.containsKey(value)) {
            return stringToEnum.get(value);
        }
        throw new IllegalArgumentException(String.format("ConfigurationLevel with value %s is not found.", value));
    }
}

