/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.configuration;

import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.apiext.impl.ConnectivityContext;
import com.sap.core.connectivity.apiext.impl.context.AuthContext;
import com.sap.core.connectivity.apiext.impl.context.BasicAuthContext;
import com.sap.core.connectivity.apiext.impl.context.ProxyContext;
import com.sap.core.connectivity.apiext.impl.ssl.AllowAllHostnameVerifier;
import com.sap.core.connectivity.apiext.impl.ssl.BrowserCompatibleHostnameVerifier;
import com.sap.core.connectivity.apiext.impl.ssl.StrictHostnameVerifier;
import com.sap.core.connectivity.apiext.impl.ssl.TrustAllManager;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.text.MessageFormat;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class ConnectivityConfigurationContext
implements ConnectivityContext {
    private static final Logger log = Logger.getLogger(ConnectivityConfigurationContext.class);
    protected static final String TLS = "TLS";
    private static final int CONNECT_TIMEOUT_MILLIS = 30000;
    private static final int READ_TIMEOUT_MILLIS = 60000;
    private final DestinationConfiguration destinationConfiguration;

    public ConnectivityConfigurationContext(DestinationConfiguration destinationConfiguration) {
        this.destinationConfiguration = destinationConfiguration;
        this.validateConfiguration();
    }

    protected void validateConfiguration() {
        if (!this.isConfigurationPropertyInitialized("Name") || !this.isConfigurationPropertyInitialized("Type")) {
            throw new IllegalArgumentException(MessageFormat.format("Invalid destination configuration: {0} and/or {1} missing", "Name", "Type"));
        }
    }

    protected boolean isConfigurationPropertyInitialized(String property) {
        String value = this.getConfigurationProperty(property);
        return value != null && !value.isEmpty();
    }

    protected String getConfigurationProperty(String property) {
        return this.destinationConfiguration.getProperty(property);
    }

    protected KeyStore getConfigurationKeyStore() {
        return this.destinationConfiguration.getKeyStore();
    }

    protected KeyStore getConfigurationTrustStore() {
        return this.destinationConfiguration.getTrustStore();
    }

    public String getConfigurationName() {
        return this.getConfigurationProperty("Name");
    }

    @Override
    public URL getURL() {
        return this.getURL("URL");
    }

    protected URL getURL(String urlProperty) {
        try {
            String url = this.getConfigurationProperty(urlProperty);
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory() {
        try {
            SSLContext sslContext = this.getSSLContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using SSL/TLS protocol version: " + sslContext.getProtocol()));
            }
            sslContext.init(this.getKeyManagers(), this.getTrustManagers(), null);
            return sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected SSLContext getSSLContext() throws NoSuchAlgorithmException {
        if (this.isConfigurationPropertyInitialized("TLSVersion")) {
            try {
                return SSLContext.getInstance(this.getConfigurationProperty("TLSVersion"));
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IllegalArgumentException(String.format("Invalid %s property: %s", "TLSVersion", this.getConfigurationProperty("TLSVersion")), ex);
            }
        }
        return SSLContext.getInstance(TLS);
    }

    protected KeyManager[] getKeyManagers() throws GeneralSecurityException {
        KeyManager[] keyManagerArray;
        KeyManager keyManager = this.createKeyManager();
        if (keyManager != null) {
            KeyManager[] keyManagerArray2 = new KeyManager[1];
            keyManagerArray = keyManagerArray2;
            keyManagerArray2[0] = keyManager;
        } else {
            keyManagerArray = null;
        }
        return keyManagerArray;
    }

    protected KeyManager createKeyManager() throws GeneralSecurityException {
        KeyStore keyStore = this.getConfigurationKeyStore();
        if (keyStore != null) {
            String keyStorePassword = this.getConfigurationProperty("KeyStorePassword");
            return this.createKeyManager(keyStore, keyStorePassword.toCharArray());
        }
        return null;
    }

    protected KeyManager createKeyManager(KeyStore keyStore, char[] keyStorePassword) throws GeneralSecurityException {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, keyStorePassword);
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            if (keyManagers != null && keyManagers.length > 0) {
                return keyManagers[0];
            }
            return null;
        }
        catch (UnrecoverableKeyException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    protected TrustManager[] getTrustManagers() throws GeneralSecurityException {
        TrustManager[] trustManagerArray;
        TrustManager trustManager;
        TrustManager trustManager2 = trustManager = this.isTrustAll() ? this.createTrustAllManager() : this.createTrustManager();
        if (trustManager != null) {
            TrustManager[] trustManagerArray2 = new TrustManager[1];
            trustManagerArray = trustManagerArray2;
            trustManagerArray2[0] = trustManager;
        } else {
            trustManagerArray = null;
        }
        return trustManagerArray;
    }

    protected boolean isTrustAll() {
        return Boolean.parseBoolean(this.getConfigurationProperty("TrustAll"));
    }

    protected TrustManager createTrustAllManager() throws GeneralSecurityException {
        return new TrustAllManager();
    }

    protected TrustManager createTrustManager() throws GeneralSecurityException {
        KeyStore trustStore = this.getConfigurationTrustStore();
        if (trustStore != null) {
            return this.createTrustManager(trustStore);
        }
        return null;
    }

    protected X509TrustManager createTrustManager(KeyStore trustStore) throws GeneralSecurityException {
        TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmfactory.init(trustStore);
        TrustManager[] trustManagers = tmfactory.getTrustManagers();
        if (trustManagers != null && trustManagers.length > 0) {
            return (X509TrustManager)trustManagers[0];
        }
        return null;
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.isTrustAll() ? this.createAllowAllHostnameVerifier() : this.createHostnameVerifier();
    }

    protected HostnameVerifier createAllowAllHostnameVerifier() {
        return new AllowAllHostnameVerifier();
    }

    protected HostnameVerifier createHostnameVerifier() {
        if (this.isConfigurationPropertyInitialized("HostnameVerifier")) {
            String hostnameVerifier = this.getConfigurationProperty("HostnameVerifier");
            if ("BrowserCompatible".equals(hostnameVerifier)) {
                return new BrowserCompatibleHostnameVerifier();
            }
            if ("Strict".equals(hostnameVerifier)) {
                return new StrictHostnameVerifier();
            }
            throw new IllegalArgumentException(String.format("Host Name Verifier %s not found.", hostnameVerifier));
        }
        return new StrictHostnameVerifier();
    }

    @Override
    public int getConnectTimeoutMillis() {
        return 30000;
    }

    @Override
    public int getReadTimeoutMillis() {
        return 60000;
    }

    @Override
    public AuthContext getAuthContext() {
        BasicAuthContext authContext = null;
        if (this.isConfigurationPropertyInitialized("User")) {
            String username = this.getConfigurationProperty("User");
            String password = this.isConfigurationPropertyInitialized("Password") ? this.getConfigurationProperty("Password") : "";
            authContext = new BasicAuthContext(username, password);
        }
        return authContext;
    }

    @Override
    public ProxyContext getProxyContext() {
        Proxy proxy = Proxy.NO_PROXY;
        try {
            if (!this.isConfigurationPropertyInitialized("ProxyType") || "Internet".equals(this.getConfigurationProperty("ProxyType"))) {
                ProxySelector defaultProxySelector = ProxySelector.getDefault();
                proxy = defaultProxySelector.select(this.getURL().toURI()).get(0);
            }
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        return new ProxyContext(proxy);
    }

    protected boolean isOnPremise() {
        return "OnPremise".equals(this.getConfigurationProperty("ProxyType"));
    }

    public String getOnPremiseLocationId() {
        return this.isOnPremise() ? this.getConfigurationProperty("CloudConnectorLocationId") : null;
    }
}

