/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.configuration;

import com.sap.core.connectivity.apiext.impl.configuration.DestinationConfigurationException;
import com.sap.core.connectivity.apiext.impl.configuration.DestinationNotAvailableException;
import com.sap.core.connectivity.apiext.impl.configuration.provider.HTML5ConfigurationProvider;
import com.sap.core.connectivity.apiext.internal.api.configuration.HTML5Configuration;
import com.sap.core.connectivity.apiext.internal.api.configuration.HTML5DestinationConfiguration;
import com.sap.core.connectivity.apiext.internal.api.configuration.HTML5DestinationMetadata;
import org.apache.log4j.Logger;

public abstract class HTML5AbstractConfiguration
implements HTML5Configuration {
    private static final Logger LOGGER = Logger.getLogger(HTML5AbstractConfiguration.class);
    protected final HTML5ConfigurationProvider configurationProvider;

    protected HTML5AbstractConfiguration(HTML5ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    public HTML5DestinationConfiguration get(HTML5DestinationMetadata destinationMetadata) {
        try {
            return this.configurationProvider.getDestinationConfiguration(destinationMetadata);
        }
        catch (DestinationNotAvailableException ex) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Missing HTML5 destination with metadata " + destinationMetadata), (Throwable)ex);
            }
            return null;
        }
        catch (DestinationConfigurationException ex) {
            throw new IllegalStateException("Cannot get HTML5 destination with metadata " + destinationMetadata, ex);
        }
    }
}

