/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.configuration;

import com.sap.core.connectivity.apiext.impl.configuration.AbstractDestinationConfiguration;
import com.sap.core.connectivity.apiext.impl.configuration.ConfigurationLevel;
import com.sap.core.connectivity.apiext.impl.configuration.DestinationConfigurationException;
import com.sap.core.connectivity.apiext.impl.configuration.HTML5KeyStoreMetadata;
import com.sap.core.connectivity.apiext.impl.configuration.provider.HTML5ConfigurationProvider;
import com.sap.core.connectivity.apiext.impl.keystore.KeyStoreFactory;
import com.sap.core.connectivity.apiext.internal.api.configuration.HTML5DestinationConfiguration;
import com.sap.core.connectivity.apiext.internal.api.configuration.HTML5DestinationMetadata;
import java.security.KeyStore;
import java.util.Properties;

public class HTML5DestinationConfigurationImpl
extends AbstractDestinationConfiguration
implements HTML5DestinationConfiguration {
    private final HTML5DestinationMetadata destinationMetadata;
    private final HTML5ConfigurationProvider configurationProvider;

    public HTML5DestinationConfigurationImpl(HTML5DestinationMetadata destinationMetadata, HTML5ConfigurationProvider configurationProvider, Properties configurationProperties, ConfigurationLevel configurationLevel, KeyStoreFactory keyStoreFactory) {
        super(configurationProperties, configurationLevel, keyStoreFactory);
        this.destinationMetadata = destinationMetadata;
        this.configurationProvider = configurationProvider;
    }

    @Override
    protected KeyStore loadKeyStore(String keyStoreName, String keyStorePassword) throws DestinationConfigurationException {
        String providerAccountId = this.destinationMetadata.getProviderAccountId();
        String applicationName = this.destinationMetadata.getApplicationName();
        String consumerAccountId = this.destinationMetadata.getConsumerAccountId();
        String subscriptionName = this.destinationMetadata.getSubscriptionName();
        HTML5KeyStoreMetadata html5KeyStoreMetadata = new HTML5KeyStoreMetadata(providerAccountId, applicationName, consumerAccountId, subscriptionName, keyStoreName, keyStorePassword, this.getConfigurationLevel());
        return this.configurationProvider.getKeyStore(html5KeyStoreMetadata);
    }

    public HTML5DestinationConfiguration.ResolutionType getResolutionType() {
        ConfigurationLevel cl = this.getConfigurationLevel();
        if (cl == null) {
            return null;
        }
        switch (cl) {
            case APPLICATION: {
                return HTML5DestinationConfiguration.ResolutionType.APPLICATION;
            }
            case SUBSCRIPTION: {
                return HTML5DestinationConfiguration.ResolutionType.SUBSCRIPTION;
            }
            case TENANT: {
                return HTML5DestinationConfiguration.ResolutionType.TENANT;
            }
            case FILESYSTEM: {
                return HTML5DestinationConfiguration.ResolutionType.FILESYSTEM;
            }
        }
        throw new IllegalArgumentException((Object)((Object)cl) + " is not a supported ConfigurationLevel value");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.destinationMetadata == null ? 0 : this.destinationMetadata.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HTML5DestinationConfigurationImpl other = (HTML5DestinationConfigurationImpl)obj;
        return !(this.destinationMetadata == null ? other.destinationMetadata != null : !this.destinationMetadata.equals((Object)other.destinationMetadata));
    }
}

