/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.configuration.provider;

import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.apiext.impl.configuration.ConfigurationLevel;
import com.sap.core.connectivity.apiext.impl.configuration.DestinationConfigurationException;
import com.sap.core.connectivity.apiext.impl.configuration.DestinationConfigurationImpl;
import com.sap.core.connectivity.apiext.impl.configuration.DestinationNotAvailableException;
import com.sap.core.connectivity.apiext.impl.configuration.provider.ConfigurationProvider;
import com.sap.core.connectivity.apiext.impl.configuration.reader.ConfigurationReader;
import com.sap.core.connectivity.apiext.impl.datasource.object.DestinationConfigurationObject;
import com.sap.core.connectivity.apiext.impl.datasource.object.KeystoreConfigurationObject;
import com.sap.core.connectivity.apiext.impl.keystore.KeyStoreFactory;
import com.sap.core.connectivity.apiext.impl.keystore.KeyStoreType;
import com.sap.core.connectivity.apiext.impl.keystore.KeyStoreUtil;
import com.sap.core.connectivity.apiext.impl.validation.DestinationValidation;
import com.sap.core.connectivity.apiext.impl.validation.DestinationValidationException;
import com.sap.core.connectivity.apiext.impl.validation.DestinationValidationFactory;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ConfigurationProviderImpl
implements ConfigurationProvider {
    private static final Logger log = Logger.getLogger(ConfigurationProviderImpl.class);
    private static final Pattern NAME_PATTERN = Pattern.compile("^([A-Za-z0-9-_]+)$");
    private static final String ERR_MESSAGE_WRONG_DEST_NAME = "Destination name: %s is not valid. %s";
    private static final String ERR_MESSAGE_EMPTY_DEST_NAME = "Name can not be empty.";
    private static final String ERR_MESSAGE_LONG_DEST_NAME = "Name length must not exceed 200 characters.";
    private static final String ERR_MESSAGE_INVALID_CHARS_IN_DEST_NAME = "Name may contain only word characters (letters, digits, underscores) and dashes.";
    protected final ConfigurationReader configurationReader;
    protected final KeyStoreFactory keyStoreFactory;

    public ConfigurationProviderImpl(ConfigurationReader configurationReader, KeyStoreFactory keystoreFactory) {
        this.configurationReader = configurationReader;
        this.keyStoreFactory = keystoreFactory;
    }

    @Override
    public DestinationConfiguration getDestinationConfiguration(final String name) throws DestinationConfigurationException {
        return this.provideDestinationConfiguration(new DestinationConfigurationProvider(this){

            @Override
            public DestinationConfigurationObject load() throws IOException {
                return configurationReader.readDestinationConfiguration(name);
            }
        }, name);
    }

    protected DestinationConfiguration provideDestinationConfiguration(DestinationConfigurationProvider destinationConfigurationProvider, String name) throws DestinationConfigurationException {
        this.validateDestinationConfigurationName(name);
        try {
            DestinationConfiguration destinationConfiguration = this.provide(destinationConfigurationProvider);
            if (destinationConfiguration == null) {
                throw new DestinationNotAvailableException("Destination configuration with name " + name + " not found");
            }
            return destinationConfiguration;
        }
        catch (IOException ex) {
            throw new DestinationConfigurationException("Error while reading destination configuration with name " + name, ex);
        }
    }

    protected void validateDestinationConfigurationName(String name) throws IllegalArgumentException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException(String.format(ERR_MESSAGE_WRONG_DEST_NAME, name, ERR_MESSAGE_EMPTY_DEST_NAME));
        }
        if (name.length() > 200) {
            throw new IllegalArgumentException(String.format(ERR_MESSAGE_WRONG_DEST_NAME, name, ERR_MESSAGE_LONG_DEST_NAME));
        }
        Matcher matcher = NAME_PATTERN.matcher(name);
        if (!matcher.find()) {
            throw new IllegalArgumentException(String.format(ERR_MESSAGE_WRONG_DEST_NAME, name, ERR_MESSAGE_INVALID_CHARS_IN_DEST_NAME));
        }
    }

    @Override
    public Map<String, DestinationConfiguration> getDestinationConfigurations() throws DestinationConfigurationException {
        return this.provideDestinationConfigurations(new DestinationConfigurationsProvider<String>(this){

            @Override
            public List<DestinationConfigurationObject> load() throws IOException {
                return configurationReader.readDestinationConfigurations();
            }

            @Override
            protected String getDestinationConfigurationKey(DestinationConfiguration destinationConfiguration) {
                return destinationConfiguration.getProperty("Name");
            }
        });
    }

    protected <TDestinationConfigurationKey> Map<TDestinationConfigurationKey, DestinationConfiguration> provideDestinationConfigurations(DestinationConfigurationsProvider<TDestinationConfigurationKey> destinationConfigurationsProvider) throws DestinationConfigurationException {
        try {
            Map destinationConfigurationMap = (Map)this.provide(destinationConfigurationsProvider);
            if (destinationConfigurationMap == null || destinationConfigurationMap.isEmpty()) {
                throw new DestinationNotAvailableException("Destination configurations cannot be found");
            }
            return destinationConfigurationMap;
        }
        catch (IOException ex) {
            throw new DestinationConfigurationException("Error while reading destination configurations", ex);
        }
    }

    protected void validateDestinationConfiguration(DestinationConfigurationObject destinationConfiguration) throws DestinationValidationException {
        Properties properties = destinationConfiguration.getProperties();
        String typeProperty = properties.getProperty("Type");
        DestinationValidation.DestinationType type = DestinationValidation.DestinationType.getType(typeProperty);
        DestinationValidation destinationValidation = DestinationValidationFactory.getDestinationValidation(type);
        String[] validationErrorMessages = destinationValidation.validate(destinationConfiguration);
        if (validationErrorMessages != null && validationErrorMessages.length > 0) {
            throw new DestinationValidationException(validationErrorMessages);
        }
    }

    protected DestinationConfiguration createDestinationConfiguration(DestinationConfigurationObject destinationConfiguration) {
        return new DestinationConfigurationImpl(this, destinationConfiguration.getProperties(), destinationConfiguration.getConfigurationLevel(), this.keyStoreFactory);
    }

    @Override
    public KeyStore getKeyStore(String destinationName, final String keyStorePath, String keyStorePassword, final ConfigurationLevel configurationLevel) throws DestinationConfigurationException {
        return this.provideKeyStore(new KeyStoreProvider(this){

            @Override
            public KeystoreConfigurationObject load() throws IOException {
                return configurationReader.readKeystoreConfiguration(keyStorePath, configurationLevel);
            }
        }, keyStorePath, keyStorePassword);
    }

    protected KeyStore provideKeyStore(KeyStoreProvider keyStoreProvider, String keyStorePath, String keyStorePassword) throws DestinationConfigurationException {
        KeyStoreType keyStoreType = KeyStoreUtil.getTypeByPath(keyStorePath);
        if (keyStoreType != null) {
            try {
                InputStream keyStoreInputStream = this.provide(keyStoreProvider);
                if (keyStoreInputStream == null) {
                    throw new DestinationNotAvailableException("Keystore configuration on path " + keyStorePath + " cannot be found");
                }
                return this.createKeyStore(keyStoreType, keyStoreInputStream, keyStorePassword);
            }
            catch (IOException ex) {
                throw new DestinationConfigurationException("Error while reading keystore configuration from path " + keyStorePath, ex);
            }
        }
        throw new IllegalArgumentException("Keystore '" + keyStorePath + "' does not have a valid extension. The allowed extensions are: " + KeyStoreUtil.ALLOWED_EXTESIONS);
    }

    protected KeyStore createKeyStore(KeyStoreType keyStoreType, InputStream keyStoreInputStream, String keyStorePassword) {
        try {
            return this.keyStoreFactory.create(keyStoreType, keyStoreInputStream, keyStorePassword);
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private <TInput, TOutput> TOutput provide(Provider<TInput, TOutput> provider) throws IOException {
        TInput input = provider.load();
        return input != null ? (TOutput)provider.convert(input) : null;
    }

    protected abstract class DestinationConfigurationProvider
    implements Provider<DestinationConfigurationObject, DestinationConfiguration> {
        protected DestinationConfigurationProvider() {
        }

        @Override
        public DestinationConfiguration convert(DestinationConfigurationObject destinationConfiguration) {
            ConfigurationProviderImpl.this.validateDestinationConfiguration(destinationConfiguration);
            return ConfigurationProviderImpl.this.createDestinationConfiguration(destinationConfiguration);
        }
    }

    protected abstract class DestinationConfigurationsProvider<TDestinationConfigurationKey>
    implements Provider<List<DestinationConfigurationObject>, Map<TDestinationConfigurationKey, DestinationConfiguration>> {
        protected DestinationConfigurationsProvider() {
        }

        @Override
        public Map<TDestinationConfigurationKey, DestinationConfiguration> convert(List<DestinationConfigurationObject> destinationConfigurations) {
            HashMap<TDestinationConfigurationKey, DestinationConfiguration> destinationConfigurationMap = new HashMap<TDestinationConfigurationKey, DestinationConfiguration>(destinationConfigurations.size());
            for (DestinationConfigurationObject destinationConfigurationObject : destinationConfigurations) {
                try {
                    ConfigurationProviderImpl.this.validateDestinationConfiguration(destinationConfigurationObject);
                    DestinationConfiguration destinationConfiguration = ConfigurationProviderImpl.this.createDestinationConfiguration(destinationConfigurationObject);
                    TDestinationConfigurationKey destinationConfigurationKey = this.getDestinationConfigurationKey(destinationConfiguration);
                    destinationConfigurationMap.put(destinationConfigurationKey, destinationConfiguration);
                }
                catch (Exception ex) {
                    log.error((Object)"Error while processing a destination configuration", (Throwable)ex);
                }
            }
            return destinationConfigurationMap;
        }

        protected abstract TDestinationConfigurationKey getDestinationConfigurationKey(DestinationConfiguration var1);
    }

    protected abstract class KeyStoreProvider
    implements Provider<KeystoreConfigurationObject, InputStream> {
        protected KeyStoreProvider() {
        }

        @Override
        public InputStream convert(KeystoreConfigurationObject keystoreConfiguration) throws IOException {
            return keystoreConfiguration.createInputStream();
        }
    }

    private static interface Provider<TInput, TOutput> {
        public TInput load() throws IOException;

        public TOutput convert(TInput var1) throws IOException;
    }
}

