/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.configuration.provider;

import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.apiext.impl.configuration.DestinationConfigurationException;
import com.sap.core.connectivity.apiext.impl.configuration.HTML5DestinationConfigurationImpl;
import com.sap.core.connectivity.apiext.impl.configuration.HTML5KeyStoreMetadata;
import com.sap.core.connectivity.apiext.impl.configuration.provider.ConfigurationProviderImpl;
import com.sap.core.connectivity.apiext.impl.configuration.provider.HTML5ConfigurationProvider;
import com.sap.core.connectivity.apiext.impl.configuration.reader.HTML5ConfigurationReader;
import com.sap.core.connectivity.apiext.impl.datasource.object.DestinationConfigurationObject;
import com.sap.core.connectivity.apiext.impl.datasource.object.KeystoreConfigurationObject;
import com.sap.core.connectivity.apiext.impl.keystore.KeyStoreFactory;
import com.sap.core.connectivity.apiext.internal.api.configuration.HTML5DestinationConfiguration;
import com.sap.core.connectivity.apiext.internal.api.configuration.HTML5DestinationMetadata;
import com.sap.core.connectivity.apiext.internal.api.configuration.InvalidHTML5DestinationMetadataException;
import java.io.IOException;
import java.security.KeyStore;

public class HTML5ConfigurationProviderImpl
extends ConfigurationProviderImpl
implements HTML5ConfigurationProvider {
    protected final HTML5ConfigurationReader html5ConfigurationReader;

    public HTML5ConfigurationProviderImpl(HTML5ConfigurationReader html5ConfigurationReader, KeyStoreFactory keystoreFactory) {
        super(html5ConfigurationReader, keystoreFactory);
        this.html5ConfigurationReader = html5ConfigurationReader;
    }

    @Override
    public HTML5DestinationConfiguration getDestinationConfiguration(final HTML5DestinationMetadata destinationMetadata) throws DestinationConfigurationException {
        return (HTML5DestinationConfiguration)this.provideDestinationConfiguration(new ConfigurationProviderImpl.DestinationConfigurationProvider(this){

            @Override
            public DestinationConfigurationObject load() throws IOException {
                return HTML5ConfigurationProviderImpl.this.html5ConfigurationReader.readDestinationConfiguration(destinationMetadata);
            }

            @Override
            public DestinationConfiguration convert(DestinationConfigurationObject destinationConfiguration) {
                HTML5ConfigurationProviderImpl.this.validateDestinationConfiguration(destinationConfiguration);
                return HTML5ConfigurationProviderImpl.this.createDestinationConfiguration(destinationConfiguration, destinationMetadata);
            }
        }, destinationMetadata.getDestination());
    }

    @Override
    protected void validateDestinationConfigurationName(String name) throws InvalidHTML5DestinationMetadataException {
        try {
            super.validateDestinationConfigurationName(name);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidHTML5DestinationMetadataException("Invalid destination name " + name, (Throwable)ex);
        }
    }

    protected HTML5DestinationConfiguration createDestinationConfiguration(DestinationConfigurationObject destinationConfiguration, HTML5DestinationMetadata destinationMetadata) {
        return new HTML5DestinationConfigurationImpl(destinationMetadata, this, destinationConfiguration.getProperties(), destinationConfiguration.getConfigurationLevel(), this.keyStoreFactory);
    }

    @Override
    public KeyStore getKeyStore(final HTML5KeyStoreMetadata keyStoreMetadata) throws DestinationConfigurationException {
        return this.provideKeyStore(new ConfigurationProviderImpl.KeyStoreProvider(this){

            @Override
            public KeystoreConfigurationObject load() throws IOException {
                return HTML5ConfigurationProviderImpl.this.html5ConfigurationReader.readKeystoreConfiguration(keyStoreMetadata);
            }
        }, keyStoreMetadata.getKeyStoreName(), keyStoreMetadata.getKeyStorePassword());
    }
}

