/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.configuration.reader;

import com.sap.core.connectivity.apiext.impl.configuration.ConfigurationLevel;
import com.sap.core.connectivity.apiext.impl.configuration.reader.ConfigurationReader;
import com.sap.core.connectivity.apiext.impl.datasource.DataSource;
import com.sap.core.connectivity.apiext.impl.datasource.object.DestinationConfigurationObject;
import com.sap.core.connectivity.apiext.impl.datasource.object.KeystoreConfigurationObject;
import java.io.IOException;
import java.util.List;

public class DataSourceConfigurationReader
implements ConfigurationReader {
    protected final DataSource dataSource;

    public DataSourceConfigurationReader(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public DestinationConfigurationObject readDestinationConfiguration(String name) throws IOException {
        return this.dataSource.getDestinationConfiguration(name).orNull();
    }

    @Override
    public List<DestinationConfigurationObject> readDestinationConfigurations() throws IOException {
        return this.dataSource.getDestinationConfigurations().orNull();
    }

    @Override
    public KeystoreConfigurationObject readKeystoreConfiguration(String keyStorePath, ConfigurationLevel configurationLevel) throws IOException {
        return this.dataSource.getKeystoreConfiguration(keyStorePath, configurationLevel).orNull();
    }
}

