/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.context;

import com.sap.core.connectivity.apiext.impl.context.Header;
import com.sap.core.connectivity.apiext.impl.context.HeaderAuthContext;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;

public class BasicAuthContext
extends HeaderAuthContext {
    public static final String HEADER_NAME_AUTHORIZATION = "Authorization";
    private static final String AUTH_TYPE_BASIC = "BASIC";

    public BasicAuthContext(String username, String password) {
        try {
            String authCredentials = String.valueOf(username) + ":" + password;
            String encodedCredentials = new String(BASE64Encoder.encode((byte[])authCredentials.getBytes("UTF-8")), "UTF-8");
            LinkedList<Header> h = new LinkedList<Header>();
            h.add(new Header(this.getAuthorizationHeaderName(), "Basic " + encodedCredentials));
            this.setHeaders(h);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public String getAuthType() {
        return AUTH_TYPE_BASIC;
    }

    protected String getAuthorizationHeaderName() {
        return HEADER_NAME_AUTHORIZATION;
    }
}

