/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.context;

import com.sap.core.connectivity.apiext.impl.context.Header;
import com.sap.core.connectivity.apiext.impl.context.HeaderAuthContext;
import java.security.cert.Certificate;
import java.util.LinkedList;
import javax.xml.bind.DatatypeConverter;

public class S2SSslClientCertAuthContext
extends HeaderAuthContext {
    private static final String AUTH_TYPE_S2S_CLIENT_CERT = "S2S CLIENT CERT";
    private static final String HEADER_NAME_SSL_CLIENT_CERTIFICATE = "SSL_CLIENT_CERT";

    public S2SSslClientCertAuthContext(Certificate certificate) {
        try {
            String certBase64 = DatatypeConverter.printBase64Binary((byte[])certificate.getEncoded());
            LinkedList<Header> h = new LinkedList<Header>();
            h.add(new Header(HEADER_NAME_SSL_CLIENT_CERTIFICATE, certBase64));
            this.setHeaders(h);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public String getAuthType() {
        return AUTH_TYPE_S2S_CLIENT_CERT;
    }
}

