/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.datasource;

import com.sap.core.connectivity.api.configuration.NotAuthorizedException;
import com.sap.core.connectivity.apiext.impl.configuration.ConfigurationLevel;
import com.sap.core.connectivity.apiext.impl.datasource.DataSource;
import com.sap.core.connectivity.apiext.impl.datasource.object.DestinationConfigurationObject;
import com.sap.core.connectivity.apiext.impl.datasource.object.DestinationConfigurationObjectImpl;
import com.sap.core.connectivity.apiext.impl.datasource.object.KeystoreConfigurationObject;
import com.sap.core.connectivity.apiext.impl.util.Optional;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FileSystemDataSource
implements DataSource {
    private static final String DETERMINED_LOCAL_DESTINATIONS_FOLDER_AS = "Determined local destinations folder as ";
    private static final Logger log = Logger.getLogger(FileSystemDataSource.class);
    private static final String PATH_TO_RUNTIME_PROP = "path.to.runtime.installation.folder";
    private static final String DEFAULT_PATH_TO_RUNTIME = "/usr/sap/ljs";
    private static final String CONFIG_MASTER_DESTINATIONS_PATH = "/config_master/service.destinations/destinations/";
    private static final String DEFAULT_CONFIG_MASTER_DESTINATIONS_PATH = "./config_master/service.destinations/destinations/";

    @Override
    public Optional<DestinationConfigurationObject> getDestinationConfiguration(String name) throws IOException {
        File destinationFile = this.getDestinationFile(name);
        return Optional.fromNullable(this.readDestinationConfiguration(destinationFile));
    }

    @Override
    public Optional<DestinationConfigurationObject> getDestinationConfiguration(String tenantId, String name) throws IOException {
        throw new NotAuthorizedException("Tenant with id " + tenantId + " is not found");
    }

    @Override
    public Optional<List<DestinationConfigurationObject>> getDestinationConfigurations() throws IOException {
        File destinationsFolder = this.getDestinationsFolder();
        if (!destinationsFolder.isDirectory()) {
            throw new IOException(String.valueOf(destinationsFolder.getPath()) + " is not path of a folder");
        }
        File[] destinationFiles = destinationsFolder.listFiles();
        if (destinationFiles == null) {
            throw new IOException("Destination configurations cannot be read on path " + destinationsFolder.getPath());
        }
        ArrayList<DestinationConfigurationObject> destinationConfigurationObjects = new ArrayList<DestinationConfigurationObject>(destinationFiles.length);
        File[] fileArray = destinationFiles;
        int n = destinationFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File destinationFile = fileArray[n2];
            try {
                DestinationConfigurationObject destinationConfigurationObject = this.readDestinationConfiguration(destinationFile);
                if (destinationConfigurationObject != null) {
                    destinationConfigurationObjects.add(destinationConfigurationObject);
                }
            }
            catch (Exception ex) {
                log.error((Object)("Destination configuration with name " + destinationFile.getName() + " cannot be read"), (Throwable)ex);
            }
            ++n2;
        }
        if (destinationConfigurationObjects.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(destinationConfigurationObjects);
    }

    @Override
    public Optional<List<DestinationConfigurationObject>> getDestinationConfigurations(String tenantId) throws IOException {
        throw new NotAuthorizedException("Tenant with id " + tenantId + " is not found");
    }

    private File getDestinationFile(String destinationName) {
        return new File(this.getDestinationsFolder(), destinationName);
    }

    private File getDestinationsFolder() {
        String runtimeInstallFolderPath = System.getProperty(PATH_TO_RUNTIME_PROP, DEFAULT_PATH_TO_RUNTIME);
        File destinationsFolder = new File(runtimeInstallFolderPath, CONFIG_MASTER_DESTINATIONS_PATH);
        if (!destinationsFolder.exists()) {
            destinationsFolder = new File(DEFAULT_CONFIG_MASTER_DESTINATIONS_PATH);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(DETERMINED_LOCAL_DESTINATIONS_FOLDER_AS + destinationsFolder));
        }
        if (!destinationsFolder.exists()) {
            IllegalStateException illegalStateException = new IllegalStateException(String.format("The determined local destinations folder [%s] does not exist!", destinationsFolder.getAbsolutePath()));
            log.error((Object)illegalStateException);
            throw illegalStateException;
        }
        return destinationsFolder;
    }

    protected DestinationConfigurationObject readDestinationConfiguration(File destinationConfigurationFile) throws IOException {
        try {
            Properties properties = this.readDestinationProperties(destinationConfigurationFile);
            return new DestinationConfigurationObjectImpl(properties, ConfigurationLevel.FILESYSTEM);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    protected Properties readDestinationProperties(File file) throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
        }
        finally {
            this.closeQuietly(fileInputStream);
        }
        return properties;
    }

    @Override
    public Optional<KeystoreConfigurationObject> getKeystoreConfiguration(String path, ConfigurationLevel level) {
        if (!ConfigurationLevel.FILESYSTEM.equals((Object)level)) {
            throw new IllegalArgumentException("Invalid configuration level " + (Object)((Object)level));
        }
        return this.getKeystoreConfiguration(path);
    }

    @Override
    public Optional<KeystoreConfigurationObject> getKeystoreConfiguration(String tenantId, String path) {
        throw new NotAuthorizedException("Tenant with id " + tenantId + " is not found");
    }

    protected Optional<KeystoreConfigurationObject> getKeystoreConfiguration(String path) {
        return Optional.fromNullable(this.readKeystoreConfiguration(path));
    }

    private KeystoreConfigurationObject readKeystoreConfiguration(final String path) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(path);
            KeystoreConfigurationObject keystoreConfigurationObject = new KeystoreConfigurationObject(){

                @Override
                public InputStream createInputStream() throws IOException {
                    try {
                        return new FileInputStream(path);
                    }
                    catch (FileNotFoundException ex) {
                        throw new IOException(String.format("Keystore [%s] has been removed!", path), ex);
                    }
                }
            };
            return keystoreConfigurationObject;
        }
        catch (FileNotFoundException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Keystore [%s] could not be found!", path), (Throwable)ex);
            }
            return null;
        }
        finally {
            this.closeQuietly(fileInputStream);
        }
    }

    private void closeQuietly(FileInputStream fileInputStream) {
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (IOException ex) {
                log.error((Object)"Cannot close file input stream", (Throwable)ex);
            }
        }
    }

    @Override
    public String getDefaultTenantId(String accountName) {
        throw new NotAuthorizedException("Account with name " + accountName + " is not found");
    }
}

